/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.Collection;
import java.util.Iterator;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.PointcutDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.util.Strings;

public class DefinitionParserHelper {
    public static final String EXPRESSION_PREFIX = "AW_";
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$definition$Virtual;

    public static void createAndAddPointcutDefToAspectDef(String name, String expression, AspectDefinition aspectDef) {
        ExpressionNamespace namespace;
        ExpressionInfo info;
        PointcutDefinition pointcutDef = new PointcutDefinition(expression);
        aspectDef.addPointcutDefinition(pointcutDef);
        String pointcutName = name;
        String pointcutCallSignature = null;
        if (name.indexOf("(") > 0) {
            pointcutName = name.substring(0, name.indexOf("("));
            pointcutCallSignature = name.substring(name.indexOf("(") + 1, name.lastIndexOf(")"));
        }
        if ((info = (namespace = ExpressionNamespace.getNamespace(aspectDef.getQualifiedName())).getExpressionInfoOrNull(pointcutName)) == null) {
            info = new ExpressionInfo(expression, aspectDef.getQualifiedName());
            if (pointcutCallSignature != null) {
                String[] parameters = Strings.splitString(pointcutCallSignature, ",");
                for (int i = 0; i < parameters.length; ++i) {
                    String[] parameterInfo = Strings.splitString(Strings.replaceSubString(parameters[i].trim(), "  ", " "), " ");
                    info.addArgument(parameterInfo[1], parameterInfo[0], aspectDef.getClassInfo().getClassLoader());
                }
            }
        }
        ExpressionNamespace.getNamespace(aspectDef.getQualifiedName()).addExpressionInfo(pointcutName, info);
    }

    public static void createAndAddDeploymentScopeDef(String name, String expression, SystemDefinition systemDef) {
        AspectDefinition aspectDef = systemDef.getAspectDefinition((class$org$codehaus$aspectwerkz$definition$Virtual == null ? (class$org$codehaus$aspectwerkz$definition$Virtual = DefinitionParserHelper.class$("org.codehaus.aspectwerkz.definition.Virtual")) : class$org$codehaus$aspectwerkz$definition$Virtual).getName());
        aspectDef.addPointcutDefinition(new PointcutDefinition(expression));
        systemDef.addDeploymentScope(new DeploymentScope(name, expression));
    }

    public static void createAndAddAdvisableDef(String expression, SystemDefinition systemDef) {
        String newExpression;
        AspectDefinition virtualAspectDef = systemDef.getAspectDefinition((class$org$codehaus$aspectwerkz$definition$Virtual == null ? (class$org$codehaus$aspectwerkz$definition$Virtual = DefinitionParserHelper.class$("org.codehaus.aspectwerkz.definition.Virtual")) : class$org$codehaus$aspectwerkz$definition$Virtual).getName());
        virtualAspectDef.addPointcutDefinition(new PointcutDefinition(expression));
        AdviceDefinition virtualAdviceDef = (AdviceDefinition)virtualAspectDef.getBeforeAdviceDefinitions().get(0);
        ExpressionInfo oldExpressionInfo = virtualAdviceDef.getExpressionInfo();
        if (oldExpressionInfo != null) {
            String oldExpression = oldExpressionInfo.toString();
            newExpression = oldExpression + " || " + expression;
        } else {
            newExpression = expression;
        }
        virtualAdviceDef.setExpressionInfo(new ExpressionInfo(newExpression, virtualAspectDef.getQualifiedName()));
    }

    public static void attachDeploymentScopeDefsToVirtualAdvice(SystemDefinition systemDef) {
        Collection deploymentScopes;
        AspectDefinition virtualAspectDef = systemDef.getAspectDefinition((class$org$codehaus$aspectwerkz$definition$Virtual == null ? (class$org$codehaus$aspectwerkz$definition$Virtual = DefinitionParserHelper.class$("org.codehaus.aspectwerkz.definition.Virtual")) : class$org$codehaus$aspectwerkz$definition$Virtual).getName());
        AdviceDefinition virtualAdviceDef = (AdviceDefinition)virtualAspectDef.getBeforeAdviceDefinitions().get(0);
        StringBuffer newExpression = new StringBuffer();
        ExpressionInfo oldExpressionInfo = virtualAdviceDef.getExpressionInfo();
        if (oldExpressionInfo != null) {
            String oldExpression = oldExpressionInfo.toString();
            newExpression.append(oldExpression);
        }
        if ((deploymentScopes = systemDef.getDeploymentScopes()).size() != 0 && oldExpressionInfo != null) {
            newExpression.append(" || ");
        }
        Iterator it = deploymentScopes.iterator();
        while (it.hasNext()) {
            DeploymentScope deploymentScope = (DeploymentScope)it.next();
            newExpression.append(deploymentScope.getExpression());
            if (!it.hasNext()) continue;
            newExpression.append(" || ");
        }
        if (newExpression.length() != 0) {
            virtualAdviceDef.setExpressionInfo(new ExpressionInfo(newExpression.toString(), virtualAspectDef.getQualifiedName()));
        }
    }

    public static MixinDefinition createAndAddMixinDefToSystemDef(ClassInfo mixinClassInfo, String expression, DeploymentModel deploymentModel, boolean isTransient, SystemDefinition systemDef) {
        MixinDefinition mixinDef = DefinitionParserHelper.createMixinDefinition(mixinClassInfo, expression, deploymentModel, isTransient, systemDef);
        MixinDefinition doublon = null;
        Iterator intros = systemDef.getMixinDefinitions().iterator();
        while (intros.hasNext()) {
            MixinDefinition intro = (MixinDefinition)intros.next();
            if (!intro.getMixinImpl().getName().equals(mixinDef.getMixinImpl().getName())) continue;
            doublon = intro;
            intro.addExpressionInfos(mixinDef.getExpressionInfos());
            break;
        }
        if (doublon == null) {
            systemDef.addMixinDefinition(mixinDef);
        }
        return mixinDef;
    }

    public static void createAndAddInterfaceIntroductionDefToAspectDef(String expression, String introductionName, String interfaceClassName, AspectDefinition aspectDef) {
        InterfaceIntroductionDefinition introDef = DefinitionParserHelper.createInterfaceIntroductionDefinition(introductionName, expression, interfaceClassName, aspectDef);
        aspectDef.addInterfaceIntroductionDefinition(introDef);
    }

    public static AdviceDefinition createAdviceDefinition(String adviceName, AdviceType adviceType, String expression, String specialArgumentType, String aspectName, String aspectClassName, MethodInfo methodInfo, AspectDefinition aspectDef) {
        ExpressionInfo expressionInfo = new ExpressionInfo(expression, aspectDef.getQualifiedName());
        String adviceCallSignature = null;
        String resolvedSpecialArgumentType = specialArgumentType;
        if (adviceName.indexOf(40) > 0) {
            adviceCallSignature = adviceName.substring(adviceName.indexOf(40) + 1, adviceName.lastIndexOf(41));
            String[] parameters = Strings.splitString(adviceCallSignature, ",");
            for (int i = 0; i < parameters.length; ++i) {
                String paramName;
                String[] parameterInfo = Strings.splitString(Strings.replaceSubString(parameters[i].trim(), "  ", " "), " ");
                String paramType = null;
                if (parameterInfo.length == 2) {
                    paramName = parameterInfo[1];
                    paramType = parameterInfo[0];
                } else {
                    paramName = "anonymous_" + i;
                    paramType = (String)Pattern.ABBREVIATIONS.get(parameterInfo[0]);
                }
                if (paramName.equals(specialArgumentType)) {
                    resolvedSpecialArgumentType = paramType;
                    expressionInfo.setSpecialArgumentName(paramName);
                    continue;
                }
                expressionInfo.addArgument(paramName, paramType, aspectDef.getClassInfo().getClassLoader());
            }
        }
        if (adviceType.equals(AdviceType.AROUND) && !"java.lang.Object".equals(methodInfo.getReturnType().getName())) {
            throw new DefinitionException("around advice must return java.lang.Object : " + aspectClassName + "." + methodInfo.getName());
        }
        AdviceDefinition adviceDef = new AdviceDefinition(adviceName, adviceType, resolvedSpecialArgumentType, aspectName, aspectClassName, expressionInfo, methodInfo, aspectDef);
        return adviceDef;
    }

    public static MixinDefinition createMixinDefinition(ClassInfo mixinClassInfo, String expression, DeploymentModel deploymentModel, boolean isTransient, SystemDefinition systemDef) {
        MixinDefinition mixinDef = new MixinDefinition(mixinClassInfo, deploymentModel, isTransient, systemDef);
        if (expression != null) {
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, systemDef.getUuid());
            ExpressionNamespace.getNamespace(systemDef.getUuid()).addExpressionInfo(EXPRESSION_PREFIX + expression.hashCode(), expressionInfo);
            mixinDef.addExpressionInfo(expressionInfo);
        }
        return mixinDef;
    }

    public static InterfaceIntroductionDefinition createInterfaceIntroductionDefinition(String introductionName, String expression, String interfaceClassName, AspectDefinition aspectDef) {
        InterfaceIntroductionDefinition introDef = new InterfaceIntroductionDefinition(introductionName, interfaceClassName);
        if (expression != null) {
            ExpressionInfo expressionInfo = new ExpressionInfo(expression, aspectDef.getQualifiedName());
            ExpressionNamespace.getNamespace(aspectDef.getQualifiedName()).addExpressionInfo(EXPRESSION_PREFIX + expression.hashCode(), expressionInfo);
            introDef.addExpressionInfo(expressionInfo);
        }
        return introDef;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

