/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DescriptorUtil {
    private static Map _paramTypeMap = new HashMap();
    private static Map _returnTypeMap = new HashMap();

    public static String convert(String javadocSig, String javadocReturnType) {
        String javadocSigTrim = javadocSig.substring(1, javadocSig.length() - 1);
        StringTokenizer st = new StringTokenizer(javadocSigTrim, ",");
        StringBuffer jvmBuff = new StringBuffer("(");
        while (st.hasMoreTokens()) {
            String sigElement = st.nextToken().trim();
            if (!_paramTypeMap.containsKey(sigElement)) continue;
            jvmBuff.append(_paramTypeMap.get(sigElement));
        }
        jvmBuff.append(")");
        if (_returnTypeMap.containsKey(javadocReturnType)) {
            jvmBuff.append(_returnTypeMap.get(javadocReturnType));
        }
        return jvmBuff.toString();
    }

    public static String[] getParameters(String jvmSignature) {
        int i = 0;
        if (jvmSignature.charAt(i) != '(') {
            return null;
        }
        int j = 0;
        StringBuffer stringbuffer = new StringBuffer();
        ++i;
        while (i < jvmSignature.length()) {
            if (jvmSignature.charAt(i) == ')') {
                ++i;
                break;
            }
            if (i > 1) {
                stringbuffer.append(" ");
            }
            i = DescriptorUtil.jvmFormatToJavaFormat(jvmSignature, i, stringbuffer);
            ++j;
        }
        String convertedString = stringbuffer.toString();
        String[] as = new String[j];
        int k = 0;
        StringTokenizer st = new StringTokenizer(convertedString);
        while (st.hasMoreTokens()) {
            as[k++] = st.nextToken();
        }
        return as;
    }

    private static int jvmFormatToJavaFormat(String jvmFormat, int i, StringBuffer stringbuffer) {
        String s1 = "";
        while (jvmFormat.charAt(i) == '[') {
            s1 = s1 + "[]";
            ++i;
        }
        block0 : switch (jvmFormat.charAt(i)) {
            case 'B': {
                stringbuffer.append("byte");
                break;
            }
            case 'C': {
                stringbuffer.append("char");
                break;
            }
            case 'D': {
                stringbuffer.append("double");
                break;
            }
            case 'F': {
                stringbuffer.append("float");
                break;
            }
            case 'I': {
                stringbuffer.append("int");
                break;
            }
            case 'J': {
                stringbuffer.append("long");
                break;
            }
            case 'S': {
                stringbuffer.append("short");
                break;
            }
            case 'Z': {
                stringbuffer.append("boolean");
                break;
            }
            case 'V': {
                stringbuffer.append("void");
                break;
            }
            case 'L': {
                ++i;
                while (i < jvmFormat.length()) {
                    if (jvmFormat.charAt(i) == '/') {
                        stringbuffer.append('.');
                    } else {
                        if (jvmFormat.charAt(i) == ';') break block0;
                        stringbuffer.append(jvmFormat.charAt(i));
                    }
                    ++i;
                }
                break;
            }
            default: {
                return jvmFormat.length();
            }
        }
        stringbuffer = stringbuffer.append(s1);
        return ++i;
    }

    static {
        _paramTypeMap.put("byte", "B");
        _paramTypeMap.put("char", "C");
        _paramTypeMap.put("double", "D");
        _paramTypeMap.put("float", "F");
        _paramTypeMap.put("int", "I");
        _paramTypeMap.put("long", "J");
        _paramTypeMap.put("java.lang.Object", "Ljava/lang/Object;");
        _paramTypeMap.put("short", "S");
        _paramTypeMap.put("boolean", "Z");
        _paramTypeMap.put("array reference", "[");
        _returnTypeMap.put("void", "V");
    }
}

