/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.definition.DefinitionLoader;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.XmlParser;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;

public class SystemDefinitionContainer {
    public static final Map s_classLoaderSystemDefinitions = new WeakHashMap();
    public static Map s_classLoaderHierarchicalSystemDefinitions = new WeakHashMap();
    public static final Map s_classLoaderDefinitionLocations = new WeakHashMap();
    public static final String URL_JVM_OPTION_SYSTEM = System.getProperty("aspectwerkz.definition.file", "no -Daspectwerkz.definition.file");
    public static final String AOP_META_INF_XML_FILE = "META-INF/aop.xml";
    public static final String AOP_WEB_INF_XML_FILE = "../aop.xml";
    public static final String WEB_WEB_INF_XML_FILE = "../web.xml";
    private static boolean s_disableSystemWideDefinition = false;
    private static final String VIRTUAL_SYSTEM_ID_PREFIX = "virtual_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerClassLoader(ClassLoader loader) {
        Map map = s_classLoaderSystemDefinitions;
        synchronized (map) {
            if (s_classLoaderSystemDefinitions.containsKey(loader)) {
                return;
            }
            if (loader == null) {
                HashSet<SystemDefinition> defaults = new HashSet<SystemDefinition>();
                defaults.add(SystemDefinition.createVirtualDefinitionAt(loader));
                s_classLoaderSystemDefinitions.put(loader, defaults);
                s_classLoaderDefinitionLocations.put(loader, new ArrayList());
                return;
            }
            SystemDefinitionContainer.registerClassLoader(loader.getParent());
            try {
                URL def;
                HashSet<SystemDefinition> definitions = new HashSet<SystemDefinition>();
                ArrayList<URL> locationOfDefinitions = new ArrayList<URL>();
                s_classLoaderSystemDefinitions.put(loader, definitions);
                s_classLoaderDefinitionLocations.put(loader, locationOfDefinitions);
                if (loader == ClassLoader.getSystemClassLoader() && !s_disableSystemWideDefinition) {
                    definitions.addAll(DefinitionLoader.getDefaultDefinition(loader));
                    locationOfDefinitions.add(new File(URL_JVM_OPTION_SYSTEM).toURL());
                }
                if (loader.getResource(WEB_WEB_INF_XML_FILE) != null) {
                    Enumeration<URL> webres = loader.getResources(AOP_WEB_INF_XML_FILE);
                    while (webres.hasMoreElements()) {
                        def = webres.nextElement();
                        if (SystemDefinitionContainer.isDefinedBy(loader, def)) continue;
                        definitions.addAll(XmlParser.parseNoCache(loader, def));
                        locationOfDefinitions.add(def);
                    }
                }
                Enumeration<URL> res = loader.getResources(AOP_META_INF_XML_FILE);
                while (res.hasMoreElements()) {
                    def = res.nextElement();
                    if (SystemDefinitionContainer.isDefinedBy(loader, def)) continue;
                    definitions.addAll(XmlParser.parseNoCache(loader, def));
                    locationOfDefinitions.add(def);
                }
                definitions.add(SystemDefinition.createVirtualDefinitionAt(loader));
                SystemDefinitionContainer.dump(loader);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployDefinitions(ClassLoader loader, Set definitions) {
        Map map = s_classLoaderSystemDefinitions;
        synchronized (map) {
            SystemDefinitionContainer.registerClassLoader(loader);
            SystemDefinitionContainer.flushHierarchicalSystemDefinitionsBelow(loader);
            Set defs = (Set)s_classLoaderSystemDefinitions.get(loader);
            defs.addAll(definitions);
            SystemDefinitionContainer.dump(loader);
        }
    }

    private static void flushHierarchicalSystemDefinitionsBelow(ClassLoader loader) {
        WeakHashMap classLoaderHierarchicalSystemDefinitions = new WeakHashMap();
        Iterator iterator = s_classLoaderHierarchicalSystemDefinitions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ClassLoader currentLoader = (ClassLoader)entry.getKey();
            if (SystemDefinitionContainer.isChildOf(currentLoader, loader)) continue;
            classLoaderHierarchicalSystemDefinitions.put(currentLoader, entry.getValue());
        }
        s_classLoaderHierarchicalSystemDefinitions = classLoaderHierarchicalSystemDefinitions;
    }

    public static SystemDefinition getDefinitionFor(ClassLoader loader, String uuid) {
        Iterator defs = SystemDefinitionContainer.getDefinitionsFor(loader).iterator();
        while (defs.hasNext()) {
            SystemDefinition def = (SystemDefinition)defs.next();
            if (!def.getUuid().equals(uuid)) continue;
            return def;
        }
        return null;
    }

    public static Set getDefinitionsFor(ClassLoader loader) {
        return SystemDefinitionContainer.getHierarchicalDefinitionsFor(loader);
    }

    public static Set getDefinitionsAt(ClassLoader loader) {
        SystemDefinitionContainer.registerClassLoader(loader);
        return (Set)s_classLoaderSystemDefinitions.get(loader);
    }

    public static SystemDefinition getVirtualDefinitionAt(ClassLoader loader) {
        return SystemDefinitionContainer.getDefinitionFor(loader, SystemDefinitionContainer.getVirtualDefinitionUuid(loader));
    }

    public static String getVirtualDefinitionUuid(ClassLoader loader) {
        int hash = loader == null ? 0 : loader.hashCode();
        StringBuffer sb = new StringBuffer(VIRTUAL_SYSTEM_ID_PREFIX);
        return sb.append(hash).toString();
    }

    public static void disableSystemWideDefinition() {
        s_disableSystemWideDefinition = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getHierarchicalDefinitionsFor(ClassLoader loader) {
        Map map = s_classLoaderSystemDefinitions;
        synchronized (map) {
            if (s_classLoaderHierarchicalSystemDefinitions.containsKey(loader)) {
                return (Set)s_classLoaderHierarchicalSystemDefinitions.get(loader);
            }
            SystemDefinitionContainer.registerClassLoader(loader);
            HashSet defs = new HashSet();
            s_classLoaderHierarchicalSystemDefinitions.put(loader, defs);
            if (loader != null) {
                ClassLoader parent = loader.getParent();
                defs.addAll(SystemDefinitionContainer.getHierarchicalDefinitionsFor(parent));
            }
            defs.addAll((Set)s_classLoaderSystemDefinitions.get(loader));
            return defs;
        }
    }

    private static boolean isDefinedBy(ClassLoader loader, URL def) {
        if (loader == null) {
            return false;
        }
        ArrayList defLocation = (ArrayList)s_classLoaderDefinitionLocations.get(loader);
        if (defLocation != null) {
            Iterator it = defLocation.iterator();
            while (it.hasNext()) {
                URL definedDef = (URL)it.next();
                if (!definedDef.sameFile(def)) continue;
                return true;
            }
        }
        return SystemDefinitionContainer.isDefinedBy(loader.getParent(), def);
    }

    private static void dump(ClassLoader loader) {
        if (!AspectWerkzPreProcessor.VERBOSE) {
            return;
        }
        StringBuffer dump = new StringBuffer("******************************************************************");
        dump.append("\n* ClassLoader = ");
        if (loader != null && loader.toString().length() < 120) {
            dump.append(loader.toString()).append("@").append(loader.hashCode());
        } else if (loader != null) {
            dump.append(loader.getClass().getName()).append("@").append(loader.hashCode());
        } else {
            dump.append("null");
        }
        Set defs = (Set)s_classLoaderSystemDefinitions.get(loader);
        Iterator it = defs.iterator();
        while (it.hasNext()) {
            SystemDefinition def = (SystemDefinition)it.next();
            dump.append("\n* SystemID = ").append(def.getUuid());
            dump.append(", ").append(def.getAspectDefinitions().size()).append(" aspects.");
        }
        it = ((List)s_classLoaderDefinitionLocations.get(loader)).iterator();
        while (it.hasNext()) {
            dump.append("\n* ").append(it.next());
        }
        dump.append("\n******************************************************************");
        System.out.println(dump.toString());
    }

    public static boolean isChildOf(ClassLoader loader, ClassLoader parentLoader) {
        if (loader == null) {
            return parentLoader == null;
        }
        if (loader.equals(parentLoader)) {
            return true;
        }
        return SystemDefinitionContainer.isChildOf(loader.getParent(), parentLoader);
    }
}

