/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression.regexp;

import java.io.ObjectInputStream;
import org.codehaus.aspectwerkz.expression.ExpressionException;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.util.Strings;

public class NamePattern
extends Pattern {
    protected transient com.karneim.util.collection.regex.Pattern m_namePattern;
    protected String m_pattern;

    NamePattern(String pattern) {
        this.m_pattern = pattern;
        this.escape(this.m_pattern);
    }

    public boolean matches(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (name.equals("")) {
            return false;
        }
        return this.m_namePattern.contains(name);
    }

    public String getPattern() {
        return this.m_pattern;
    }

    protected void escape(String namePattern) {
        try {
            namePattern = namePattern.equals("*") ? "[a-zA-Z0-9_$.]+" : Strings.replaceSubString(namePattern, "*", "[a-zA-Z0-9_$]*");
            this.m_namePattern = new com.karneim.util.collection.regex.Pattern(namePattern);
        }
        catch (Throwable e) {
            throw new ExpressionException("type pattern is not well formed: " + namePattern, e);
        }
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        this.m_pattern = (String)fields.get("m_pattern", null);
        this.escape(this.m_pattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + NamePattern.hashCodeOrZeroIfNull(this.m_pattern);
        result = 37 * result + NamePattern.hashCodeOrZeroIfNull(this.m_namePattern);
        return result;
    }

    protected static int hashCodeOrZeroIfNull(Object o) {
        if (null == o) {
            return 19;
        }
        return o.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamePattern)) {
            return false;
        }
        NamePattern obj = (NamePattern)o;
        return NamePattern.areEqualsOrBothNull(obj.m_pattern, this.m_pattern) && NamePattern.areEqualsOrBothNull(obj.m_namePattern, this.m_namePattern);
    }

    protected static boolean areEqualsOrBothNull(Object o1, Object o2) {
        if (null == o1) {
            return null == o2;
        }
        return o1.equals(o2);
    }
}

