/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.hook;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.hook.ClassLoaderPatcher;

public class JDWPClassLoaderPatcher {
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;
    static /* synthetic */ Class class$java$util$Map;

    private static void redefineClass(VirtualMachine vm, String className, byte[] bytes) {
        try {
            Method canM = (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = JDWPClassLoaderPatcher.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("canRedefineClasses", new Class[0]);
            if (((Boolean)canM.invoke((Object)vm, new Object[0])).equals(Boolean.FALSE)) {
                throw new Error("target JVM cannot redefine classes, please force the use of -Xbootclasspath");
            }
            List<ReferenceType> classList = vm.classesByName(className);
            if (classList.size() == 0) {
                throw new Error("Fatal error: Can't find class " + className);
            }
            ReferenceType rt = classList.get(0);
            HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
            map.put(rt, bytes);
            Method doM = (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = JDWPClassLoaderPatcher.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("redefineClasses", class$java$util$Map == null ? (class$java$util$Map = JDWPClassLoaderPatcher.class$("java.util.Map")) : class$java$util$Map);
            doM.invoke((Object)vm, map);
        }
        catch (NoSuchMethodException e) {
            throw new Error("target JVM cannot redefine classes, please force the use of -Xbootclasspath");
        }
        catch (InvocationTargetException e) {
            System.err.println("failed to HotSwap " + className + ':');
            e.getTargetException().printStackTrace();
            throw new Error("try to force force the use of -Xbootclasspath");
        }
        catch (IllegalAccessException e) {
            System.err.println("failed to HotSwap " + className + ':');
            e.printStackTrace();
            throw new Error("try to force force the use of -Xbootclasspath");
        }
    }

    public static VirtualMachine hotswapClassLoader(String preProcessorName, String transport, String address) {
        return JDWPClassLoaderPatcher.hotswapClassLoader(preProcessorName, transport, address, 0);
    }

    public static VirtualMachine hotswapClassLoader(String preProcessorName, String transport, String address, int secondsToWait) {
        String name = null;
        if ("dt_socket".equals(transport)) {
            name = "com.sun.jdi.SocketAttach";
        } else if ("dt_shmem".equals(transport)) {
            name = "com.sun.jdi.SharedMemoryAttach";
        }
        Connector connector = null;
        Iterator<AttachingConnector> i = Bootstrap.virtualMachineManager().attachingConnectors().iterator();
        while (i.hasNext()) {
            AttachingConnector aConnector = i.next();
            if (!aConnector.name().equals(name)) continue;
            connector = aConnector;
            break;
        }
        if (connector == null) {
            throw new Error("no AttachingConnector for transport: " + transport);
        }
        Map<String, Connector.Argument> args = connector.defaultArguments();
        if ("dt_socket".equals(transport)) {
            args.get("port").setValue(address);
        } else if ("dt_shmem".equals(transport)) {
            args.get("name").setValue(address);
        }
        try {
            if (secondsToWait > 0) {
                try {
                    Thread.sleep(1000 * secondsToWait);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            VirtualMachine vm = null;
            ConnectException vmConnectionRefused = new ConnectException("should not appear as is");
            for (int retry = 0; retry < 10; ++retry) {
                try {
                    vm = connector.attach(args);
                    break;
                }
                catch (ConnectException ce) {
                    vmConnectionRefused = ce;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (vm == null) {
                throw vmConnectionRefused;
            }
            JDWPClassLoaderPatcher.redefineClass(vm, "java.lang.ClassLoader", ClassLoaderPatcher.getPatchedClassLoader(preProcessorName));
            return vm;
        }
        catch (IllegalConnectorArgumentsException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            Iterator<String> i2 = e.argumentNames().iterator();
            while (i2.hasNext()) {
                System.err.println("wrong or missing argument - " + i2.next());
            }
            return null;
        }
        catch (IOException e) {
            System.err.println("failed to attach to VM (" + transport + ", " + address + "):");
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

