/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.TypeConverter;
import org.codehaus.aspectwerkz.util.Strings;

public final class MethodComparator
implements Comparator {
    public static final int NORMAL_METHOD = 0;
    public static final int PREFIXED_METHOD = 1;
    public static final int METHOD_INFO = 2;
    private final int m_type;

    private MethodComparator(int type) {
        this.m_type = type;
    }

    public static Comparator getInstance(int type) {
        return new MethodComparator(type);
    }

    public int compare(Object o1, Object o2) {
        switch (this.m_type) {
            case 0: {
                return this.compareNormal((Method)o1, (Method)o2);
            }
            case 1: {
                return this.comparePrefixed((Method)o1, (Method)o2);
            }
            case 2: {
                return this.compareMethodInfo((MethodInfo)o1, (MethodInfo)o2);
            }
        }
        throw new RuntimeException("invalid method comparison type");
    }

    private int compareNormal(Method m1, Method m2) {
        try {
            Class<?>[] args2;
            String m2Name;
            if (m1.equals(m2)) {
                return 0;
            }
            String m1Name = m1.getName();
            if (!m1Name.equals(m2Name = m2.getName())) {
                return m1Name.compareTo(m2Name);
            }
            Class<?>[] args1 = m1.getParameterTypes();
            if (args1.length < (args2 = m2.getParameterTypes()).length) {
                return -1;
            }
            if (args1.length > args2.length) {
                return 1;
            }
            if (args1.length == 0) {
                return 0;
            }
            for (int i = 0; i < args1.length; ++i) {
                int result = TypeConverter.convertTypeToJava(args1[i]).compareTo(TypeConverter.convertTypeToJava(args2[i]));
                if (result == 0) continue;
                return result;
            }
        }
        catch (Throwable e) {
            throw new WrappedRuntimeException(e);
        }
        System.err.println(m1.getName());
        System.err.println(m2.getName());
        throw new Error("should be unreachable");
    }

    private int comparePrefixed(Method m1, Method m2) {
        try {
            Class<?>[] args2;
            String[] m2Tokens;
            String m2Name;
            if (m1.equals(m2)) {
                return 0;
            }
            String[] m1Tokens = Strings.splitString(m1.getName(), "$_AW_$");
            String m1Name = m1Tokens[1];
            if (!m1Name.equals(m2Name = (m2Tokens = Strings.splitString(m2.getName(), "$_AW_$"))[1])) {
                return m1Name.compareTo(m2Name);
            }
            Class<?>[] args1 = m1.getParameterTypes();
            if (args1.length < (args2 = m2.getParameterTypes()).length) {
                return -1;
            }
            if (args1.length > args2.length) {
                return 1;
            }
            if (args1.length == 0) {
                return 0;
            }
            for (int i = 0; i < args1.length; ++i) {
                int result = TypeConverter.convertTypeToJava(args1[i]).compareTo(TypeConverter.convertTypeToJava(args2[i]));
                if (result == 0) continue;
                return result;
            }
        }
        catch (Throwable e) {
            throw new WrappedRuntimeException(e);
        }
        System.err.println(m1.getName());
        System.err.println(m2.getName());
        throw new Error("should be unreachable");
    }

    private int compareMethodInfo(MethodInfo m1, MethodInfo m2) {
        try {
            ClassInfo[] args2;
            String m2Name;
            if (m1.equals(m2)) {
                return 0;
            }
            String m1Name = m1.getName();
            if (!m1Name.equals(m2Name = m2.getName())) {
                return m1Name.compareTo(m2Name);
            }
            ClassInfo[] args1 = m1.getParameterTypes();
            if (args1.length < (args2 = m2.getParameterTypes()).length) {
                return -1;
            }
            if (args1.length > args2.length) {
                return 1;
            }
            if (args1.length == 0) {
                return 0;
            }
            for (int i = 0; i < args1.length; ++i) {
                int result = args1[i].getName().equals(args2[i].getName()) ? 0 : args1[i].getName().compareTo(args2[i].getName());
                if (result == 0) continue;
                return result;
            }
        }
        catch (Throwable e) {
            throw new WrappedRuntimeException(e);
        }
        System.err.println(m1.getName());
        System.err.println(m2.getName());
        throw new Error("should be unreachable");
    }
}

