/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Properties;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;

public class AsmClassInfoRepository {
    private static final TIntObjectHashMap s_repositories = new TIntObjectHashMap();
    private final TIntObjectHashMap m_repository;
    private final transient WeakReference m_loaderRef;
    private final Properties m_annotationProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsmClassInfoRepository(ClassLoader loader) {
        block10: {
            this.m_repository = new TIntObjectHashMap();
            this.m_loaderRef = new WeakReference<ClassLoader>(loader);
            this.m_annotationProperties = new Properties();
            if (loader != null) {
                try {
                    InputStream stream = loader.getResourceAsStream("annotation.properties");
                    if (stream == null) break block10;
                    try {
                        this.m_annotationProperties.load(stream);
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException e) {
                    throw new DefinitionException("could not find resource [annotation.properties] on classpath");
                }
            }
        }
    }

    public static synchronized AsmClassInfoRepository getRepository(ClassLoader loader) {
        AsmClassInfoRepository repository;
        int hash = loader == null ? 0 : loader.hashCode();
        Reference repositoryRef = (Reference)s_repositories.get(hash);
        AsmClassInfoRepository asmClassInfoRepository = repository = repositoryRef == null ? null : (AsmClassInfoRepository)repositoryRef.get();
        if (repository != null) {
            return repository;
        }
        AsmClassInfoRepository repo = new AsmClassInfoRepository(loader);
        s_repositories.put(hash, new SoftReference<AsmClassInfoRepository>(repo));
        return repo;
    }

    public static void removeClassInfoFromAllClassLoaders(String className) {
        throw new UnsupportedOperationException("fix algorithm");
    }

    public ClassInfo getClassInfo(String className) {
        ClassInfo info;
        Reference classInfoRef = (Reference)this.m_repository.get(className.hashCode());
        ClassInfo classInfo = info = classInfoRef == null ? null : (ClassInfo)classInfoRef.get();
        if (info == null) {
            return this.checkParentClassRepository(className, (ClassLoader)this.m_loaderRef.get());
        }
        return info;
    }

    public void addClassInfo(ClassInfo classInfo) {
        if (this.checkParentClassRepository(classInfo.getName(), (ClassLoader)this.m_loaderRef.get()) == null) {
            this.m_repository.put(classInfo.getName().hashCode(), new SoftReference<ClassInfo>(classInfo));
        }
    }

    public boolean hasClassInfo(String name) {
        Reference classInfoRef = (Reference)this.m_repository.get(name.hashCode());
        return classInfoRef == null ? false : classInfoRef.get() != null;
    }

    public void removeClassInfo(String className) {
        this.m_repository.remove(className.hashCode());
    }

    public Properties getAnnotationProperties() {
        return this.m_annotationProperties;
    }

    public ClassInfo checkParentClassRepository(String className, ClassLoader loader) {
        if (loader == null) {
            return null;
        }
        ClassLoader parent = loader.getParent();
        if (parent == null) {
            return null;
        }
        ClassInfo info = AsmClassInfoRepository.getRepository(parent).getClassInfo(className);
        if (info != null) {
            return info;
        }
        return this.checkParentClassRepository(className, parent);
    }
}

