/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.MethodStruct;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;

public class AsmConstructorInfo
extends AsmMemberInfo
implements ConstructorInfo {
    private String[] m_parameterTypeNames = null;
    private String[] m_exceptionTypeNames = null;
    private ClassInfo[] m_parameterTypes = null;
    private ClassInfo[] m_exceptionTypes = null;

    AsmConstructorInfo(MethodStruct method, String declaringType, ClassLoader loader) {
        super(method, declaringType, loader);
        Type[] argTypes = Type.getArgumentTypes(method.desc);
        this.m_parameterTypeNames = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            this.m_parameterTypeNames[i] = argTypes[i].getClassName();
        }
        this.m_exceptionTypeNames = new String[0];
    }

    public static ConstructorInfo getConstructorInfo(String constructorDesc, byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(className);
        if (classInfo == null) {
            classInfo = AsmClassInfo.getClassInfo(bytecode, loader);
        }
        return classInfo.getConstructor(AsmHelper.calculateConstructorHash(constructorDesc));
    }

    public String getSignature() {
        return AsmHelper.getConstructorDescriptor(this);
    }

    public ClassInfo[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            this.m_parameterTypes = new ClassInfo[this.m_parameterTypeNames.length];
            for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
                this.m_parameterTypes[i] = AsmClassInfo.getClassInfo(this.m_parameterTypeNames[i], (ClassLoader)this.m_loaderRef.get());
            }
        }
        return this.m_parameterTypes;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.m_exceptionTypes == null) {
            this.m_exceptionTypes = new ClassInfo[this.m_exceptionTypeNames.length];
            for (int i = 0; i < this.m_exceptionTypeNames.length; ++i) {
                this.m_exceptionTypes[i] = AsmClassInfo.getClassInfo(this.m_exceptionTypeNames[i], (ClassLoader)this.m_loaderRef.get());
            }
        }
        return this.m_exceptionTypes;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getDeclaringType().getAnnotationReader().getConstructorAnnotationElements(this.m_member.desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo constructorInfo = (ConstructorInfo)o;
        if (!this.m_declaringTypeName.equals(constructorInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.name.equals(constructorInfo.getName())) {
            return false;
        }
        ClassInfo[] parameterTypes = constructorInfo.getParameterTypes();
        if (this.m_parameterTypeNames.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
            if (this.m_parameterTypeNames[i].equals(parameterTypes[i].getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringTypeName.hashCode();
        result = 29 * result + this.m_member.name.hashCode();
        for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
            result = 29 * result + this.m_parameterTypeNames[i].hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_declaringTypeName);
        sb.append('.').append(this.m_member.name);
        sb.append(this.m_member.desc);
        return sb.toString();
    }
}

