/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.asm;

import java.lang.reflect.Modifier;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmMemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.MethodStruct;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;

public class AsmMethodInfo
extends AsmMemberInfo
implements MethodInfo {
    private String m_returnTypeName = null;
    protected String[] m_parameterNames = null;
    private String[] m_parameterTypeNames = null;
    private String[] m_exceptionTypeNames = null;
    private ClassInfo m_returnType = null;
    private ClassInfo[] m_parameterTypes = null;
    private ClassInfo[] m_exceptionTypes = null;

    AsmMethodInfo(MethodStruct method, String declaringType, ClassLoader loader) {
        super(method, declaringType, loader);
        this.m_returnTypeName = Type.getReturnType(method.desc).getClassName();
        Type[] argTypes = Type.getArgumentTypes(method.desc);
        this.m_parameterTypeNames = new String[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            this.m_parameterTypeNames[i] = argTypes[i].getClassName();
        }
        this.m_exceptionTypeNames = new String[0];
    }

    public static MethodInfo getMethodInfo(String methodName, String methodDesc, byte[] bytecode, ClassLoader loader) {
        String className = AsmClassInfo.retrieveClassNameFromBytecode(bytecode);
        AsmClassInfoRepository repository = AsmClassInfoRepository.getRepository(loader);
        ClassInfo classInfo = repository.getClassInfo(className);
        if (classInfo == null) {
            classInfo = AsmClassInfo.getClassInfo(bytecode, loader);
        }
        return classInfo.getMethod(AsmHelper.calculateMethodHash(methodName, methodDesc));
    }

    public String getSignature() {
        return AsmHelper.getMethodDescriptor(this);
    }

    public ClassInfo getReturnType() {
        if (this.m_returnType == null) {
            this.m_returnType = AsmClassInfo.getClassInfo(this.m_returnTypeName, (ClassLoader)this.m_loaderRef.get());
        }
        return this.m_returnType;
    }

    public ClassInfo[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            this.m_parameterTypes = new ClassInfo[this.m_parameterTypeNames.length];
            for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
                this.m_parameterTypes[i] = AsmClassInfo.getClassInfo(this.m_parameterTypeNames[i], (ClassLoader)this.m_loaderRef.get());
            }
        }
        return this.m_parameterTypes;
    }

    public String[] getParameterNames() {
        return this.m_parameterNames;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.m_exceptionTypes == null) {
            this.m_exceptionTypes = new ClassInfo[this.m_exceptionTypeNames.length];
            for (int i = 0; i < this.m_exceptionTypeNames.length; ++i) {
                this.m_exceptionTypes[i] = AsmClassInfo.getClassInfo(this.m_exceptionTypeNames[i], (ClassLoader)this.m_loaderRef.get());
            }
        }
        return this.m_exceptionTypes;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getDeclaringType().getAnnotationReader().getMethodAnnotationElements(this.m_member.name, this.m_member.desc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo methodInfo = (MethodInfo)o;
        if (!this.m_declaringTypeName.equals(methodInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.name.equals(methodInfo.getName())) {
            return false;
        }
        ClassInfo[] parameterTypes = methodInfo.getParameterTypes();
        if (this.m_parameterTypeNames.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
            if (this.m_parameterTypeNames[i].equals(parameterTypes[i].getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringTypeName.hashCode();
        result = 29 * result + this.m_member.name.hashCode();
        for (int i = 0; i < this.m_parameterTypeNames.length; ++i) {
            result = 29 * result + this.m_parameterTypeNames[i].hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_declaringTypeName);
        sb.append('.').append(this.m_member.name);
        sb.append(this.m_member.desc);
        return sb.toString();
    }

    public void pushParameterNameFromRegister(int registerIndex, String parameterName) {
        int registerStart = 1;
        if (Modifier.isStatic(this.m_member.modifiers)) {
            registerStart = 0;
        }
        int registerIndexFrom0 = registerIndex - registerStart;
        Type[] parameters = Type.getArgumentTypes(this.m_member.desc);
        int typeIndex = AsmHelper.getTypeIndexOf(parameters, registerIndexFrom0);
        if (typeIndex < 0 || typeIndex >= this.m_parameterNames.length) {
            throw new DefinitionException("Could not register parameter named " + parameterName + " from register " + registerIndex + " for " + this.m_member.name + "." + this.m_member.desc);
        }
        this.m_parameterNames[typeIndex] = parameterName;
    }
}

