/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.java;

import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfoImpl;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaConstructorInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaFieldInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaMethodInfo;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;
import org.codehaus.backport175.reader.bytecode.AnnotationReader;

public class JavaClassInfo
implements ClassInfo {
    private final Class m_class;
    private String m_name;
    private String m_signature;
    private boolean m_isInterface = false;
    private boolean m_isPrimitive = false;
    private boolean m_isArray = false;
    private final TIntObjectHashMap m_constructors = new TIntObjectHashMap();
    private final TIntObjectHashMap m_methods = new TIntObjectHashMap();
    private final TIntObjectHashMap m_fields = new TIntObjectHashMap();
    private ClassInfo[] m_interfaces = null;
    private ClassInfo m_superClass = null;
    private ClassInfo m_componentType = null;
    private final JavaClassInfoRepository m_classInfoRepository;
    private StaticInitializationInfo m_staticInitializer = null;

    JavaClassInfo(Class klass) {
        if (klass == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        this.m_class = klass;
        this.m_signature = ReflectHelper.getClassSignature(klass);
        this.m_classInfoRepository = JavaClassInfoRepository.getRepository(klass.getClassLoader());
        this.m_isInterface = klass.isInterface();
        if (klass.isPrimitive()) {
            this.m_name = klass.getName();
            this.m_isPrimitive = true;
        } else if (klass.getComponentType() != null) {
            this.m_name = JavaClassInfo.convertJavaArrayTypeNameToHumanTypeName(klass.getName());
            this.m_isArray = true;
            this.m_interfaces = new ClassInfo[0];
        } else {
            this.m_name = klass.getName();
            Method[] methods = this.m_class.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.m_methods.put(ReflectHelper.calculateHash(method), new JavaMethodInfo(method, this));
            }
            Constructor<?>[] constructors = this.m_class.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                this.m_constructors.put(ReflectHelper.calculateHash(constructor), new JavaConstructorInfo(constructor, this));
            }
            Field[] fields = this.m_class.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getName().startsWith("___AW_")) continue;
                Field field = fields[i];
                this.m_fields.put(ReflectHelper.calculateHash(field), new JavaFieldInfo(field, this));
            }
        }
        this.m_classInfoRepository.addClassInfo(this);
    }

    public static ClassInfo getClassInfo(Class clazz) {
        JavaClassInfoRepository repository = JavaClassInfoRepository.getRepository(clazz.getClassLoader());
        ClassInfo classInfo = repository.getClassInfo(clazz.getName());
        if (classInfo == null) {
            classInfo = new JavaClassInfo(clazz);
        }
        return classInfo;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getAnnotationReader().getAnnotationElements();
    }

    public String getName() {
        return this.m_name.replace('/', '.');
    }

    public boolean hasStaticInitializer() {
        ClassInfo classInfo = AsmClassInfo.getClassInfo(this.getName(), this.getClassLoader());
        return classInfo.hasStaticInitializer();
    }

    public StaticInitializationInfo staticInitializer() {
        if (this.hasStaticInitializer() && this.m_staticInitializer == null) {
            this.m_staticInitializer = new StaticInitializationInfoImpl(this);
        }
        return this.m_staticInitializer;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public int getModifiers() {
        return this.m_class.getModifiers();
    }

    public ClassLoader getClassLoader() {
        return this.m_class.getClassLoader();
    }

    public ConstructorInfo getConstructor(int hash) {
        ConstructorInfo constructor = (ConstructorInfo)this.m_constructors.get(hash);
        if (constructor == null && this.getSuperclass() != null) {
            constructor = this.getSuperclass().getConstructor(hash);
        }
        return constructor;
    }

    public ConstructorInfo[] getConstructors() {
        Object[] values = this.m_constructors.getValues();
        ConstructorInfo[] methodInfos = new ConstructorInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            methodInfos[i] = (ConstructorInfo)values[i];
        }
        return methodInfos;
    }

    public MethodInfo getMethod(int hash) {
        MethodInfo method = (MethodInfo)this.m_methods.get(hash);
        if (method == null) {
            for (int i = 0; i < this.getInterfaces().length && (method = this.getInterfaces()[i].getMethod(hash)) == null; ++i) {
            }
        }
        if (method == null && this.getSuperclass() != null) {
            method = this.getSuperclass().getMethod(hash);
        }
        return method;
    }

    public MethodInfo[] getMethods() {
        Object[] values = this.m_methods.getValues();
        MethodInfo[] methodInfos = new MethodInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            methodInfos[i] = (MethodInfo)values[i];
        }
        return methodInfos;
    }

    public FieldInfo getField(int hash) {
        FieldInfo field = (FieldInfo)this.m_fields.get(hash);
        if (field == null && this.getSuperclass() != null) {
            field = this.getSuperclass().getField(hash);
        }
        if (field == null) {
            ClassInfo ifc;
            ClassInfo[] interfaces = this.getInterfaces();
            for (int i = 0; i < interfaces.length && (field = (ifc = interfaces[i]).getField(hash)) == null; ++i) {
            }
        }
        return field;
    }

    public FieldInfo[] getFields() {
        Object[] values = this.m_fields.getValues();
        FieldInfo[] fieldInfos = new FieldInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            fieldInfos[i] = (FieldInfo)values[i];
        }
        return fieldInfos;
    }

    public ClassInfo[] getInterfaces() {
        if (this.m_interfaces == null) {
            Class<?>[] interfaces = this.m_class.getInterfaces();
            this.m_interfaces = new ClassInfo[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                ClassInfo classInfo;
                Class<?> anInterface = interfaces[i];
                this.m_interfaces[i] = classInfo = JavaClassInfo.getClassInfo(anInterface);
                if (this.m_classInfoRepository.hasClassInfo(anInterface.getName())) continue;
                this.m_classInfoRepository.addClassInfo(classInfo);
            }
        }
        return this.m_interfaces;
    }

    public ClassInfo getSuperclass() {
        Class superclass;
        if (this.m_superClass == null && (superclass = this.m_class.getSuperclass()) != null) {
            if (this.m_classInfoRepository.hasClassInfo(superclass.getName())) {
                this.m_superClass = this.m_classInfoRepository.getClassInfo(superclass.getName());
            } else {
                this.m_superClass = JavaClassInfo.getClassInfo(superclass);
                this.m_classInfoRepository.addClassInfo(this.m_superClass);
            }
        }
        return this.m_superClass;
    }

    public ClassInfo getComponentType() {
        if (this.isArray() && this.m_componentType == null) {
            Class<?> componentType = this.m_class.getComponentType();
            if (this.m_classInfoRepository.hasClassInfo(componentType.getName())) {
                this.m_componentType = this.m_classInfoRepository.getClassInfo(componentType.getName());
            } else {
                this.m_componentType = JavaClassInfo.getClassInfo(componentType);
                this.m_classInfoRepository.addClassInfo(this.m_componentType);
            }
        }
        return this.m_componentType;
    }

    public boolean isInterface() {
        return this.m_isInterface;
    }

    public boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    public boolean isArray() {
        return this.m_isArray;
    }

    public static String convertJavaArrayTypeNameToHumanTypeName(String typeName) {
        int index = typeName.lastIndexOf(91);
        if (index != -1) {
            StringBuffer arrayType = new StringBuffer();
            if (typeName.endsWith("I")) {
                arrayType.append("int");
            } else if (typeName.endsWith("J")) {
                arrayType.append("long");
            } else if (typeName.endsWith("S")) {
                arrayType.append("short");
            } else if (typeName.endsWith("F")) {
                arrayType.append("float");
            } else if (typeName.endsWith("D")) {
                arrayType.append("double");
            } else if (typeName.endsWith("Z")) {
                arrayType.append("boolean");
            } else if (typeName.endsWith("C")) {
                arrayType.append("char");
            } else if (typeName.endsWith("B")) {
                arrayType.append("byte");
            } else {
                arrayType.append(typeName.substring(index + 2, typeName.length() - 1));
            }
            for (int i = 0; i < index + 1; ++i) {
                arrayType.append("[]");
            }
            return arrayType.toString();
        }
        return typeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassInfo)) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)o;
        return this.m_class.getName().toString().equals(classInfo.getName().toString());
    }

    public int hashCode() {
        return this.m_class.getName().toString().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public AnnotationReader getAnnotationReader() {
        return AnnotationReader.getReaderFor(this.m_class);
    }
}

