/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.java;

import java.lang.reflect.Field;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaMemberInfo;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;

public class JavaFieldInfo
extends JavaMemberInfo
implements FieldInfo {
    private ClassInfo m_type = null;
    private String m_signature;

    JavaFieldInfo(Field field, JavaClassInfo declaringType) {
        super(field, declaringType);
        this.m_signature = ReflectHelper.getFieldSignature(field);
    }

    public static FieldInfo getFieldInfo(Field field) {
        Class<?> declaringClass = field.getDeclaringClass();
        JavaClassInfoRepository repository = JavaClassInfoRepository.getRepository(declaringClass.getClassLoader());
        ClassInfo classInfo = repository.getClassInfo(declaringClass.getName());
        if (classInfo == null) {
            classInfo = JavaClassInfo.getClassInfo(declaringClass);
        }
        return classInfo.getField(ReflectHelper.calculateHash(field));
    }

    public String getSignature() {
        return this.m_signature;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getDeclaringType().getAnnotationReader().getFieldAnnotationElements(this.getName(), this.m_signature);
    }

    public ClassInfo getType() {
        if (this.m_type == null) {
            Class<?> type = ((Field)this.m_member).getType();
            if (this.m_classInfoRepository.hasClassInfo(type.getName())) {
                this.m_type = this.m_classInfoRepository.getClassInfo(type.getName());
            } else {
                this.m_type = JavaClassInfo.getClassInfo(type);
                this.m_classInfoRepository.addClassInfo(this.m_type);
            }
        }
        return this.m_type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)o;
        if (!this.m_declaringType.getName().equals(fieldInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.getName().equals(fieldInfo.getName())) {
            return false;
        }
        ClassInfo fieldType = fieldInfo.getType();
        return this.m_type.getName().equals(fieldType.getName());
    }

    public int hashCode() {
        int result = 29;
        if (this.m_type == null) {
            this.getType();
        }
        result = 29 * result + this.m_declaringType.getName().hashCode();
        result = 29 * result + this.m_member.getName().hashCode();
        result = 29 * result + this.getType().getName().hashCode();
        return result;
    }
}

