/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.java;

import java.lang.reflect.Method;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaMemberInfo;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;

public class JavaMethodInfo
extends JavaMemberInfo
implements MethodInfo {
    private ClassInfo m_returnType = null;
    private ClassInfo[] m_parameterTypes = null;
    private ClassInfo[] m_exceptionTypes = null;
    private String m_signature;

    JavaMethodInfo(Method method, JavaClassInfo declaringType) {
        super(method, declaringType);
        this.m_signature = ReflectHelper.getMethodSignature(method);
    }

    public static MethodInfo getMethodInfo(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        JavaClassInfoRepository repository = JavaClassInfoRepository.getRepository(declaringClass.getClassLoader());
        ClassInfo classInfo = repository.getClassInfo(declaringClass.getName());
        if (classInfo == null) {
            classInfo = JavaClassInfo.getClassInfo(declaringClass);
        }
        return classInfo.getMethod(ReflectHelper.calculateHash(method));
    }

    public String getSignature() {
        return this.m_signature;
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.getDeclaringType().getAnnotationReader().getMethodAnnotationElements(this.m_member.getName(), this.m_signature);
    }

    public ClassInfo getReturnType() {
        if (this.m_returnType == null) {
            Class<?> returnTypeClass = ((Method)this.m_member).getReturnType();
            if (this.m_classInfoRepository.hasClassInfo(returnTypeClass.getName())) {
                this.m_returnType = this.m_classInfoRepository.getClassInfo(returnTypeClass.getName());
            } else {
                this.m_returnType = JavaClassInfo.getClassInfo(returnTypeClass);
                this.m_classInfoRepository.addClassInfo(this.m_returnType);
            }
        }
        return this.m_returnType;
    }

    public ClassInfo[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            Class<?>[] parameterTypes = ((Method)this.m_member).getParameterTypes();
            this.m_parameterTypes = new ClassInfo[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                ClassInfo metaData;
                Class<?> parameterType = parameterTypes[i];
                if (this.m_classInfoRepository.hasClassInfo(parameterType.getName())) {
                    metaData = this.m_classInfoRepository.getClassInfo(parameterType.getName());
                } else {
                    metaData = JavaClassInfo.getClassInfo(parameterType);
                    this.m_classInfoRepository.addClassInfo(metaData);
                }
                this.m_parameterTypes[i] = metaData;
            }
        }
        return this.m_parameterTypes;
    }

    public String[] getParameterNames() {
        return null;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.m_exceptionTypes == null) {
            Class<?>[] exceptionTypes = ((Method)this.m_member).getExceptionTypes();
            this.m_exceptionTypes = new ClassInfo[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                ClassInfo metaData;
                Class<?> exceptionType = exceptionTypes[i];
                if (this.m_classInfoRepository.hasClassInfo(exceptionType.getName())) {
                    metaData = this.m_classInfoRepository.getClassInfo(exceptionType.getName());
                } else {
                    metaData = JavaClassInfo.getClassInfo(exceptionType);
                    this.m_classInfoRepository.addClassInfo(metaData);
                }
                this.m_exceptionTypes[i] = metaData;
            }
        }
        return this.m_exceptionTypes;
    }

    public boolean equals(Object o) {
        ClassInfo[] parameterTypes2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodInfo)) {
            return false;
        }
        MethodInfo methodInfo = (MethodInfo)o;
        if (!this.m_declaringType.getName().equals(methodInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.getName().equals(methodInfo.getName())) {
            return false;
        }
        Class<?>[] parameterTypes1 = ((Method)this.m_member).getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = methodInfo.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            if (parameterTypes1[i].getName().equals(parameterTypes2[i].getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringType.getName().hashCode();
        result = 29 * result + this.m_member.getName().hashCode();
        Class<?>[] parameterTypes = ((Method)this.m_member).getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result = 29 * result + parameterTypes[i].getName().hashCode();
        }
        return result;
    }

    public String toString() {
        return this.m_member.toString();
    }
}

