/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import org.codehaus.aspectwerkz.joinpoint.management.JoinPointType;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.transform.Context;

public final class EmittedJoinPoint {
    public static final Label NO_LINE_NUMBER = new Label();
    private final int joinPointType;
    private final String callerClassName;
    private final String callerMethodName;
    private final String callerMethodDesc;
    private final int callerMethodModifiers;
    private final String calleeClassName;
    private final String calleeMemberName;
    private final String calleeMemberDesc;
    private final int calleeMemberModifiers;
    private final int joinPointHash;
    private final String joinPointClassName;
    private final Label lineNumberLabel;
    private int lineNumber = 0;

    public EmittedJoinPoint(int joinPointType, String callerClassName, String callerMethodName, String callerMethodDesc, int callerMethodModifiers, String calleeClassName, String calleeMemberName, String calleeMemberDesc, int calleeMemberModifiers, int joinPointHash, String joinPointClassName, Label lineNumberLabel) {
        this.joinPointType = joinPointType;
        this.callerClassName = callerClassName;
        this.callerMethodName = callerMethodName;
        this.callerMethodDesc = callerMethodDesc;
        this.callerMethodModifiers = callerMethodModifiers;
        this.calleeClassName = calleeClassName;
        this.calleeMemberName = calleeMemberName;
        this.calleeMemberDesc = calleeMemberDesc;
        this.calleeMemberModifiers = calleeMemberModifiers;
        this.joinPointHash = joinPointHash;
        this.joinPointClassName = joinPointClassName;
        this.lineNumberLabel = lineNumberLabel;
    }

    public EmittedJoinPoint(int joinPointType, String callerClassName, String callerMethodName, String callerMethodDesc, int callerMethodModifiers, String calleeClassName, String calleeMemberName, String calleeMemberDesc, int calleeMemberModifiers, int joinPointHash, String joinPointClassName) {
        this(joinPointType, callerClassName, callerMethodName, callerMethodDesc, callerMethodModifiers, calleeClassName, calleeMemberName, calleeMemberDesc, calleeMemberModifiers, joinPointHash, joinPointClassName, NO_LINE_NUMBER);
    }

    public int getJoinPointType() {
        return this.joinPointType;
    }

    public String getCallerClassName() {
        return this.callerClassName;
    }

    public String getCallerMethodName() {
        return this.callerMethodName;
    }

    public String getCallerMethodDesc() {
        return this.callerMethodDesc;
    }

    public int getCallerMethodModifiers() {
        return this.callerMethodModifiers;
    }

    public String getCalleeClassName() {
        return this.calleeClassName;
    }

    public String getCalleeMemberName() {
        return this.calleeMemberName;
    }

    public String getCalleeMemberDesc() {
        return this.calleeMemberDesc;
    }

    public int getCalleeMemberModifiers() {
        return this.calleeMemberModifiers;
    }

    public int getJoinPointHash() {
        return this.joinPointHash;
    }

    public String getJoinPointClassName() {
        return this.joinPointClassName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void resolveLineNumber(Context context) {
        this.lineNumber = context.resolveLineNumberInfo(this.lineNumberLabel);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmittedJoinPoint)) {
            return false;
        }
        EmittedJoinPoint emittedJoinPoint = (EmittedJoinPoint)o;
        if (this.calleeMemberModifiers != emittedJoinPoint.calleeMemberModifiers) {
            return false;
        }
        if (this.callerMethodModifiers != emittedJoinPoint.callerMethodModifiers) {
            return false;
        }
        if (this.joinPointHash != emittedJoinPoint.joinPointHash) {
            return false;
        }
        if (this.joinPointType != emittedJoinPoint.joinPointType) {
            return false;
        }
        if (!this.calleeClassName.equals(emittedJoinPoint.calleeClassName)) {
            return false;
        }
        if (!this.calleeMemberDesc.equals(emittedJoinPoint.calleeMemberDesc)) {
            return false;
        }
        if (!this.calleeMemberName.equals(emittedJoinPoint.calleeMemberName)) {
            return false;
        }
        if (!this.callerClassName.equals(emittedJoinPoint.callerClassName)) {
            return false;
        }
        if (!this.callerMethodDesc.equals(emittedJoinPoint.callerMethodDesc)) {
            return false;
        }
        if (!this.callerMethodName.equals(emittedJoinPoint.callerMethodName)) {
            return false;
        }
        return this.joinPointClassName.equals(emittedJoinPoint.joinPointClassName);
    }

    public int hashCode() {
        int result = this.joinPointType;
        result = 29 * result + this.callerClassName.hashCode();
        result = 29 * result + this.callerMethodName.hashCode();
        result = 29 * result + this.callerMethodDesc.hashCode();
        result = 29 * result + this.callerMethodModifiers;
        result = 29 * result + this.calleeClassName.hashCode();
        result = 29 * result + this.calleeMemberName.hashCode();
        result = 29 * result + this.calleeMemberDesc.hashCode();
        result = 29 * result + this.calleeMemberModifiers;
        result = 29 * result + this.joinPointHash;
        result = 29 * result + this.joinPointClassName.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(JoinPointType.fromInt(this.getJoinPointType()).toString());
        sb.append(" , caller ");
        sb.append(this.getCallerClassName());
        sb.append('.').append(this.getCallerMethodName());
        sb.append(this.getCallerMethodDesc());
        sb.append(" , callee ");
        sb.append(this.getCalleeClassName());
        sb.append('.').append(this.getCalleeMemberName());
        sb.append(' ').append(this.getCalleeMemberDesc());
        sb.append(" , line ").append(this.getLineNumber());
        return sb.toString();
    }
}

