/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining;

import gnu.trove.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.WeavingStrategy;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AddInterfaceVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AddMixinMethodsVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AddWrapperVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;
import org.codehaus.aspectwerkz.transform.inlining.weaver.ConstructorBodyVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.ConstructorCallVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.FieldSetFieldGetVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.HandlerVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.InstanceLevelAspectVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.JoinPointInitVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.LabelToLineNumberVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.MethodCallVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.MethodExecutionVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.SerialVersionUidVisitor;
import org.codehaus.aspectwerkz.transform.inlining.weaver.StaticInitializationVisitor;

public class InliningWeavingStrategy
implements WeavingStrategy {
    public void transform(String className, Context context) {
        try {
            boolean filterForStaticinitialization;
            ExpressionContext[] ctxs;
            byte[] bytecode = context.getInitialBytecode();
            ClassLoader loader = context.getLoader();
            ClassInfo classInfo = AsmClassInfo.getClassInfo(className, bytecode, loader);
            if (classInfo.getName().startsWith("$") && classInfo.getSuperclass().getName().equals("java.lang.reflect.Proxy")) {
                context.setCurrentBytecode(context.getInitialBytecode());
                return;
            }
            Set definitions = context.getDefinitions();
            if (InliningWeavingStrategy.classFilter(definitions, ctxs = new ExpressionContext[]{new ExpressionContext(PointcutType.EXECUTION, classInfo, classInfo), new ExpressionContext(PointcutType.CALL, null, classInfo), new ExpressionContext(PointcutType.GET, null, classInfo), new ExpressionContext(PointcutType.SET, null, classInfo), new ExpressionContext(PointcutType.HANDLER, null, classInfo), new ExpressionContext(PointcutType.STATIC_INITIALIZATION, classInfo, classInfo), new ExpressionContext(PointcutType.WITHIN, classInfo, classInfo)}, classInfo)) {
                return;
            }
            boolean filterForCall = InliningWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.CALL, null, classInfo), new ExpressionContext(PointcutType.WITHIN, classInfo, classInfo)});
            boolean filterForGetSet = InliningWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.GET, null, classInfo), new ExpressionContext(PointcutType.SET, null, classInfo), new ExpressionContext(PointcutType.WITHIN, classInfo, classInfo)});
            boolean filterForHandler = InliningWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.HANDLER, null, classInfo), new ExpressionContext(PointcutType.WITHIN, classInfo, classInfo)});
            boolean bl = filterForStaticinitialization = !classInfo.hasStaticInitializer() || InliningWeavingStrategy.classFilterFor(definitions, new ExpressionContext[]{new ExpressionContext(PointcutType.STATIC_INITIALIZATION, classInfo.staticInitializer(), classInfo)});
            if (!filterForStaticinitialization) {
                filterForStaticinitialization = !InliningWeavingStrategy.hasPointcut(definitions, new ExpressionContext(PointcutType.STATIC_INITIALIZATION, classInfo.staticInitializer(), classInfo));
            }
            ClassReader crLookahead = new ClassReader(bytecode);
            TLongObjectHashMap newInvocationsByCallerMemberHash = null;
            if (!filterForCall) {
                newInvocationsByCallerMemberHash = new TLongObjectHashMap();
                crLookahead.accept(new ConstructorCallVisitor.LookaheadNewDupInvokeSpecialInstructionClassAdapter(newInvocationsByCallerMemberHash), true);
            }
            ArrayList catchLabels = new ArrayList();
            if (!filterForHandler) {
                ClassReader crLookahead2 = new ClassReader(bytecode);
                ClassWriter cw2 = AsmHelper.newClassWriter(true);
                HandlerVisitor.LookaheadCatchLabelsClassAdapter lookForCatches = new HandlerVisitor.LookaheadCatchLabelsClassAdapter(cw2, loader, classInfo, context, catchLabels);
                crLookahead2.accept(lookForCatches, null, false);
            }
            HashSet addedMethods = new HashSet();
            crLookahead.accept(new AlreadyAddedMethodAdapter(addedMethods), true);
            ClassWriter writerPhase1 = AsmHelper.newClassWriter(true);
            ClassReader readerPhase1 = new ClassReader(bytecode);
            ClassVisitor reversedChainPhase1 = writerPhase1;
            reversedChainPhase1 = new AddMixinMethodsVisitor(reversedChainPhase1, classInfo, context, addedMethods);
            reversedChainPhase1 = new AddInterfaceVisitor(reversedChainPhase1, classInfo, context);
            readerPhase1.accept(reversedChainPhase1, null, false);
            byte[] bytesPhase1 = writerPhase1.toByteArray();
            classInfo = AsmClassInfo.newClassInfo(bytesPhase1, loader);
            ClassWriter writerPhase2 = AsmHelper.newClassWriter(true);
            ClassReader readerPhase2 = new ClassReader(bytesPhase1);
            ClassVisitor reversedChainPhase2 = writerPhase2;
            reversedChainPhase2 = new InstanceLevelAspectVisitor(reversedChainPhase2, classInfo, context);
            reversedChainPhase2 = new MethodExecutionVisitor(reversedChainPhase2, classInfo, context, addedMethods);
            reversedChainPhase2 = new ConstructorBodyVisitor(reversedChainPhase2, classInfo, context, addedMethods);
            if (!filterForStaticinitialization) {
                reversedChainPhase2 = new StaticInitializationVisitor(reversedChainPhase2, context, addedMethods);
            }
            reversedChainPhase2 = new HandlerVisitor(reversedChainPhase2, context, catchLabels);
            if (!filterForCall) {
                reversedChainPhase2 = new MethodCallVisitor(reversedChainPhase2, loader, classInfo, context);
                reversedChainPhase2 = new ConstructorCallVisitor(reversedChainPhase2, loader, classInfo, context, newInvocationsByCallerMemberHash);
            }
            if (!filterForGetSet) {
                reversedChainPhase2 = new FieldSetFieldGetVisitor(reversedChainPhase2, loader, classInfo, context);
            }
            reversedChainPhase2 = new LabelToLineNumberVisitor(reversedChainPhase2, context);
            readerPhase2.accept(reversedChainPhase2, null, false);
            byte[] bytesPhase2 = writerPhase2.toByteArray();
            context.setCurrentBytecode(bytesPhase2);
            if (context.isAdvised()) {
                ClassWriter writerPhase3 = AsmHelper.newClassWriter(true);
                ClassReader readerPhase3 = new ClassReader(bytesPhase2);
                ClassVisitor reversedChainPhase3 = writerPhase3;
                reversedChainPhase3 = new SerialVersionUidVisitor.Add(reversedChainPhase3, context, classInfo);
                reversedChainPhase3 = new AddWrapperVisitor(reversedChainPhase3, context, addedMethods);
                reversedChainPhase3 = new JoinPointInitVisitor(reversedChainPhase3, context);
                readerPhase3.accept(reversedChainPhase3, null, false);
                byte[] bytesPhase3 = writerPhase3.toByteArray();
                context.setCurrentBytecode(bytesPhase3);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new WrappedRuntimeException(t);
        }
    }

    public Context newContext(String name, byte[] bytecode, ClassLoader loader) {
        return new ContextImpl(name, bytecode, loader);
    }

    private static boolean classFilter(Set definitions, ExpressionContext[] ctxs, ClassInfo classInfo) {
        if (classInfo.isInterface()) {
            return true;
        }
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (InliningWeavingStrategy.classFilter((SystemDefinition)defs.next(), ctxs, classInfo)) continue;
            return false;
        }
        return true;
    }

    private static boolean classFilter(SystemDefinition definition, ExpressionContext[] ctxs, ClassInfo classInfo) {
        if (classInfo.isInterface()) {
            return true;
        }
        String className = classInfo.getName();
        if (definition.inExcludePackage(className)) {
            return true;
        }
        if (!definition.inIncludePackage(className)) {
            return true;
        }
        if (definition.isAdvised(ctxs)) {
            return false;
        }
        if (definition.hasMixin(ctxs)) {
            return false;
        }
        if (definition.hasIntroducedInterface(ctxs)) {
            return false;
        }
        return !definition.inPreparePackage(className);
    }

    private static boolean classFilterFor(Set definitions, ExpressionContext[] ctxs) {
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (InliningWeavingStrategy.classFilterFor((SystemDefinition)defs.next(), ctxs)) continue;
            return false;
        }
        return true;
    }

    private static boolean classFilterFor(SystemDefinition definition, ExpressionContext[] ctxs) {
        return !definition.isAdvised(ctxs);
    }

    private static boolean hasPointcut(Set definitions, ExpressionContext ctx) {
        Iterator defs = definitions.iterator();
        while (defs.hasNext()) {
            if (!InliningWeavingStrategy.hasPointcut((SystemDefinition)defs.next(), ctx)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasPointcut(SystemDefinition definition, ExpressionContext ctx) {
        return definition.hasPointcut(ctx);
    }
}

