/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.aspect.container.AspectFactoryManager;
import org.codehaus.aspectwerkz.cflow.CflowCompiler;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.expression.Undeterministic;
import org.codehaus.aspectwerkz.expression.ast.ASTAnd;
import org.codehaus.aspectwerkz.expression.ast.ASTArgs;
import org.codehaus.aspectwerkz.expression.ast.ASTCall;
import org.codehaus.aspectwerkz.expression.ast.ASTCflow;
import org.codehaus.aspectwerkz.expression.ast.ASTCflowBelow;
import org.codehaus.aspectwerkz.expression.ast.ASTExecution;
import org.codehaus.aspectwerkz.expression.ast.ASTGet;
import org.codehaus.aspectwerkz.expression.ast.ASTHandler;
import org.codehaus.aspectwerkz.expression.ast.ASTHasField;
import org.codehaus.aspectwerkz.expression.ast.ASTHasMethod;
import org.codehaus.aspectwerkz.expression.ast.ASTNot;
import org.codehaus.aspectwerkz.expression.ast.ASTOr;
import org.codehaus.aspectwerkz.expression.ast.ASTPointcutReference;
import org.codehaus.aspectwerkz.expression.ast.ASTSet;
import org.codehaus.aspectwerkz.expression.ast.ASTStaticInitialization;
import org.codehaus.aspectwerkz.expression.ast.ASTTarget;
import org.codehaus.aspectwerkz.expression.ast.ASTThis;
import org.codehaus.aspectwerkz.expression.ast.ASTWithin;
import org.codehaus.aspectwerkz.expression.ast.ASTWithinCode;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Opcodes;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.compiler.AbstractJoinPointCompiler;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilerInput;

public class RuntimeCheckVisitor
extends ExpressionVisitor
implements Opcodes {
    public static final int NULL_PER_OBJECT_TYPE = -1;
    public static final int PER_THIS_TYPE = 1;
    public static final int PER_TARGET_TYPE = 2;
    private MethodVisitor cv;
    private ExpressionInfo m_expressionInfo;
    private CompilerInput m_input;
    private int m_perObjectCheckType = -1;
    private String m_aspectQName;

    public RuntimeCheckVisitor(MethodVisitor cv, ExpressionInfo info, CompilerInput input, int perObjectType, String aspectQName) {
        super(info, info.toString(), info.getNamespace(), info.getExpression().getASTRoot());
        this.m_expressionInfo = info;
        this.m_input = input;
        this.m_perObjectCheckType = perObjectType;
        this.m_aspectQName = aspectQName;
        this.cv = cv;
    }

    public void pushCheckOnStack(AdviceInfo adviceInfo) {
        super.match(adviceInfo.getExpressionContext());
        switch (this.m_perObjectCheckType) {
            case 1: {
                AbstractJoinPointCompiler.loadCaller(this.cv, this.m_input);
                this.cv.visitMethodInsn(184, AspectFactoryManager.getAspectFactoryClassName(adviceInfo.getAspectClassName(), adviceInfo.getAspectQualifiedName()), "hasAspect", "(Ljava/lang/Object;)Z");
                this.cv.visitInsn(126);
                break;
            }
            case 2: {
                AbstractJoinPointCompiler.loadCallee(this.cv, this.m_input);
                this.cv.visitMethodInsn(184, AspectFactoryManager.getAspectFactoryClassName(adviceInfo.getAspectClassName(), adviceInfo.getAspectQualifiedName()), "hasAspect", "(Ljava/lang/Object;)Z");
                this.cv.visitInsn(126);
            }
        }
    }

    public Object visit(ASTOr node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.or(matchL, matchR);
        this.cv.visitInsn(128);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.or(intermediate, matchNext);
            this.cv.visitInsn(128);
        }
        return intermediate;
    }

    public Object visit(ASTAnd node, Object data) {
        Boolean matchL = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        Boolean matchR = (Boolean)node.jjtGetChild(1).jjtAccept(this, data);
        Boolean intermediate = Undeterministic.and(matchL, matchR);
        this.cv.visitInsn(126);
        for (int i = 2; i < node.jjtGetNumChildren(); ++i) {
            Boolean matchNext = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            intermediate = Undeterministic.and(intermediate, matchNext);
            this.cv.visitInsn(126);
        }
        return intermediate;
    }

    public Object visit(ASTNot node, Object data) {
        Boolean match = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
        this.cv.visitInsn(116);
        return Undeterministic.not(match);
    }

    public Object visit(ASTTarget node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        if (match != null) {
            this.push(match);
        } else {
            String boundedTypeDesc = AsmHelper.convertReflectDescToTypeDesc(node.getBoundedType(this.m_expressionInfo));
            AbstractJoinPointCompiler.loadCallee(this.cv, this.m_input);
            this.cv.visitTypeInsn(193, boundedTypeDesc.substring(1, boundedTypeDesc.length() - 1));
        }
        return match;
    }

    public Object visit(ASTThis node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTCflow node, Object data) {
        String cflowClassName = CflowCompiler.getCflowAspectClassName(node.hashCode());
        this.cv.visitMethodInsn(184, cflowClassName, "isInCflow", "()Z");
        return (Boolean)super.visit(node, data);
    }

    public Object visit(ASTCflowBelow node, Object data) {
        String cflowClassName = CflowCompiler.getCflowAspectClassName(node.hashCode());
        this.cv.visitMethodInsn(184, cflowClassName, "isInCflow", "()Z");
        return (Boolean)super.visit(node, data);
    }

    public Object visit(ASTArgs node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTPointcutReference node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace(this.m_namespace);
        ExpressionVisitor expression = namespace.getExpression(node.getName());
        RuntimeCheckVisitor referenced = new RuntimeCheckVisitor(this.cv, expression.getExpressionInfo(), this.m_input, this.m_perObjectCheckType, this.m_aspectQName);
        return referenced.matchUndeterministic(context);
    }

    public Object visit(ASTExecution node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTCall node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTSet node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTGet node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHandler node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTStaticInitialization node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTWithin node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTWithinCode node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHasMethod node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    public Object visit(ASTHasField node, Object data) {
        Boolean match = (Boolean)super.visit(node, data);
        this.push(match);
        return match;
    }

    private void push(Boolean b) {
        if (b == null) {
            throw new Error("attempt to push an undetermined match result");
        }
        if (b.booleanValue()) {
            this.cv.visitInsn(4);
        } else {
            this.cv.visitInsn(2);
        }
    }
}

