/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import org.codehaus.aspectwerkz.org.objectweb.asm.MethodAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.transform.TransformationConstants;

public class AfterObjectInitializationCodeAdapter
extends MethodAdapter
implements TransformationConstants {
    private String m_callerMemberName;
    private int m_newCount = 0;
    private int m_invokeSpecialCount = 0;
    protected boolean m_isObjectInitialized = false;

    public AfterObjectInitializationCodeAdapter(MethodVisitor cv, String callerMemberName) {
        super(cv);
        this.m_callerMemberName = callerMemberName;
        if (!this.m_callerMemberName.equals("<init>")) {
            this.m_isObjectInitialized = true;
        }
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 187) {
            ++this.m_newCount;
        }
        super.visitTypeInsn(opcode, desc);
    }

    protected boolean queryCurrentMethodInsn(int opcode, String calleeClassName, String calleeMethodName, String calleeMethodDesc) {
        int localInvokeSpecialCount = this.m_invokeSpecialCount;
        int localNewCount = this.m_newCount;
        if (opcode == 183) {
            ++localInvokeSpecialCount;
        }
        if (this.m_callerMemberName.equals("<init>")) {
            return opcode == 183 && localNewCount == localInvokeSpecialCount - 1;
        }
        return false;
    }

    public void visitMethodInsn(int opcode, String calleeClassName, String calleeMethodName, String calleeMethodDesc) {
        if (opcode == 183) {
            ++this.m_invokeSpecialCount;
        }
        if (this.m_callerMemberName.equals("<init>") && opcode == 183 && this.m_newCount == this.m_invokeSpecialCount - 1) {
            this.m_isObjectInitialized = true;
        }
        super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
    }
}

