/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.Iterator;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.FieldVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;

public class JoinPointInitVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private boolean m_hasClinitMethod = false;
    private boolean m_hasInitJoinPointsMethod = false;
    private boolean m_hasClassField = false;
    private boolean m_hasEmittedJoinPointsField = false;

    public JoinPointInitVisitor(ClassVisitor cv, Context ctx) {
        super(cv);
        this.m_ctx = (ContextImpl)ctx;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<clinit>".equals(name)) {
            this.m_hasClinitMethod = true;
            InsertBeforeClinitCodeAdapter ca = new InsertBeforeClinitCodeAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
            ca.visitMaxs(0, 0);
            return ca;
        }
        if ("aw$initJoinPoints".equals(name)) {
            this.m_hasInitJoinPointsMethod = true;
            InsertBeforeInitJoinPointsCodeAdapter ca = new InsertBeforeInitJoinPointsCodeAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions));
            ca.visitMaxs(0, 0);
            return ca;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ("aw$clazz".equals(name)) {
            this.m_hasClassField = true;
        } else if ("aw$emittedJoinPoints".equals(name)) {
            this.m_hasEmittedJoinPointsField = true;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (!this.m_ctx.isAdvised()) {
            super.visitEnd();
            return;
        }
        if (!this.m_hasClassField) {
            this.cv.visitField(4122, "aw$clazz", "Ljava/lang/Class;", null, null);
        }
        if (!this.m_hasEmittedJoinPointsField && this.m_ctx.isMadeAdvisable()) {
            this.cv.visitField(4122, "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;", null, null);
        }
        if (!this.m_hasClinitMethod) {
            InsertBeforeClinitCodeAdapter ca = new InsertBeforeClinitCodeAdapter(this.cv.visitMethod(8, "<clinit>", "()V", null, null));
            ca.visitInsn(177);
            ca.visitMaxs(0, 0);
        }
        if (!this.m_hasInitJoinPointsMethod) {
            InsertBeforeInitJoinPointsCodeAdapter mv = new InsertBeforeInitJoinPointsCodeAdapter(this.cv.visitMethod(4122, "aw$initJoinPoints", "()V", null, null));
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
        }
        this.cv.visitEnd();
    }

    public class InsertBeforeInitJoinPointsCodeAdapter
    extends MethodAdapter {
        public InsertBeforeInitJoinPointsCodeAdapter(MethodVisitor ca) {
            super(ca);
            Iterator iterator = JoinPointInitVisitor.this.m_ctx.getEmittedJoinPoints().iterator();
            while (iterator.hasNext()) {
                EmittedJoinPoint jp = (EmittedJoinPoint)iterator.next();
                this.mv.visitLdcInsn(new Integer(jp.getJoinPointType()));
                this.mv.visitFieldInsn(178, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$clazz", "Ljava/lang/Class;");
                this.mv.visitLdcInsn(jp.getCallerMethodName());
                this.mv.visitLdcInsn(jp.getCallerMethodDesc());
                this.mv.visitLdcInsn(new Integer(jp.getCallerMethodModifiers()));
                this.mv.visitLdcInsn(jp.getCalleeClassName());
                this.mv.visitLdcInsn(jp.getCalleeMemberName());
                this.mv.visitLdcInsn(jp.getCalleeMemberDesc());
                this.mv.visitLdcInsn(new Integer(jp.getCalleeMemberModifiers()));
                this.mv.visitLdcInsn(new Integer(jp.getJoinPointHash()));
                this.mv.visitLdcInsn(jp.getJoinPointClassName());
                this.mv.visitMethodInsn(184, "org/codehaus/aspectwerkz/joinpoint/management/JoinPointManager", "loadJoinPoint", "(ILjava/lang/Class;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)V");
                if (!JoinPointInitVisitor.this.m_ctx.isMadeAdvisable()) continue;
                this.mv.visitFieldInsn(178, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;");
                this.mv.visitLdcInsn(new Integer(jp.getJoinPointClassName().hashCode()));
                this.mv.visitTypeInsn(187, "org/codehaus/aspectwerkz/transform/inlining/EmittedJoinPoint");
                this.mv.visitInsn(89);
                this.mv.visitLdcInsn(new Integer(jp.getJoinPointType()));
                this.mv.visitLdcInsn(JoinPointInitVisitor.this.m_ctx.getClassName());
                this.mv.visitLdcInsn(jp.getCallerMethodName());
                this.mv.visitLdcInsn(jp.getCallerMethodDesc());
                this.mv.visitLdcInsn(new Integer(jp.getCallerMethodModifiers()));
                this.mv.visitLdcInsn(jp.getCalleeClassName());
                this.mv.visitLdcInsn(jp.getCalleeMemberName());
                this.mv.visitLdcInsn(jp.getCalleeMemberDesc());
                this.mv.visitLdcInsn(new Integer(jp.getCalleeMemberModifiers()));
                this.mv.visitLdcInsn(new Integer(jp.getJoinPointHash()));
                this.mv.visitLdcInsn(jp.getJoinPointClassName());
                this.mv.visitMethodInsn(183, "org/codehaus/aspectwerkz/transform/inlining/EmittedJoinPoint", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;IILjava/lang/String;)V");
                this.mv.visitMethodInsn(182, "gnu/trove/TIntObjectHashMap", "put", "(ILjava/lang/Object;)Ljava/lang/Object;");
            }
        }
    }

    public class InsertBeforeClinitCodeAdapter
    extends MethodAdapter {
        public InsertBeforeClinitCodeAdapter(MethodVisitor ca) {
            super(ca);
            if (!JoinPointInitVisitor.this.m_hasClassField) {
                this.mv.visitLdcInsn(JoinPointInitVisitor.this.m_ctx.getClassName().replace('/', '.'));
                this.mv.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                this.mv.visitFieldInsn(179, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$clazz", "Ljava/lang/Class;");
            }
            if (!JoinPointInitVisitor.this.m_hasEmittedJoinPointsField && JoinPointInitVisitor.this.m_ctx.isMadeAdvisable()) {
                this.mv.visitTypeInsn(187, "gnu/trove/TIntObjectHashMap");
                this.mv.visitInsn(89);
                this.mv.visitMethodInsn(183, "gnu/trove/TIntObjectHashMap", "<init>", "()V");
                this.mv.visitFieldInsn(179, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$emittedJoinPoints", "Lgnu/trove/TIntObjectHashMap;");
            }
            if (!JoinPointInitVisitor.this.m_hasClassField) {
                this.mv.visitMethodInsn(184, JoinPointInitVisitor.this.m_ctx.getClassName(), "aw$initJoinPoints", "()V");
            }
        }
    }
}

