/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.Set;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AlreadyAddedMethodAdapter;

public class StaticInitializationVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private String m_declaringTypeName;
    private final Set m_addedMethods;

    public StaticInitializationVisitor(ClassVisitor cv, Context ctx, Set addedMethods) {
        super(cv);
        this.m_ctx = (ContextImpl)ctx;
        this.m_addedMethods = addedMethods;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_declaringTypeName = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (!"<clinit>".equals(name)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        String prefixedOriginalName = TransformationUtil.getPrefixedOriginalClinitName(this.m_declaringTypeName);
        if (this.m_addedMethods.contains(AlreadyAddedMethodAdapter.getMethodKey(prefixedOriginalName, "()V"))) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        this.m_ctx.markAsAdvised();
        this.createProxyMethod(access, name, desc, signature, exceptions);
        return this.cv.visitMethod(access + 1, prefixedOriginalName, desc, signature, exceptions);
    }

    private void createProxyMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        mv.visitInsn(1);
        int joinPointHash = AsmHelper.calculateMethodHash(name, desc);
        String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_declaringTypeName, name, desc, this.m_declaringTypeName, 8, joinPointHash);
        mv.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForCodeJoinPoints(access, desc, this.m_declaringTypeName, this.m_declaringTypeName));
        AsmHelper.addReturnStatement(mv, Type.VOID_TYPE);
        mv.visitMaxs(0, 0);
        this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(8, this.m_declaringTypeName, name, desc, access, this.m_declaringTypeName, name, desc, access, joinPointHash, joinPointClassName, EmittedJoinPoint.NO_LINE_NUMBER));
    }
}

