/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.com.thoughtworks.qdox.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.backport175.com.thoughtworks.qdox.model.AbstractJavaEntity;
import org.codehaus.backport175.com.thoughtworks.qdox.model.ClassLibrary;
import org.codehaus.backport175.com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import org.codehaus.backport175.com.thoughtworks.qdox.model.DocletTag;
import org.codehaus.backport175.com.thoughtworks.qdox.model.DocletTagFactory;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaClass;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaClassParent;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaField;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaMethod;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaParameter;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaSource;
import org.codehaus.backport175.com.thoughtworks.qdox.model.Type;
import org.codehaus.backport175.com.thoughtworks.qdox.parser.Builder;
import org.codehaus.backport175.com.thoughtworks.qdox.parser.structs.ClassDef;
import org.codehaus.backport175.com.thoughtworks.qdox.parser.structs.FieldDef;
import org.codehaus.backport175.com.thoughtworks.qdox.parser.structs.MethodDef;

public class ModelBuilder
implements Builder {
    private final ClassLibrary classLibrary;
    private final JavaSource source;
    private JavaClassParent currentParent;
    private JavaClass currentClass;
    private String lastComment;
    private List lastTagSet;
    private DocletTagFactory docletTagFactory;

    public ModelBuilder() {
        this(new ClassLibrary(null), new DefaultDocletTagFactory());
    }

    public ModelBuilder(ClassLibrary classLibrary, DocletTagFactory docletTagFactory) {
        this.classLibrary = classLibrary;
        this.docletTagFactory = docletTagFactory;
        this.source = new JavaSource();
        this.source.setClassLibrary(classLibrary);
        this.currentParent = this.source;
    }

    public void addPackage(String packageName) {
        this.source.setPackage(packageName);
    }

    public void addImport(String importName) {
        this.source.addImport(importName);
    }

    public void addJavaDoc(String text) {
        this.lastComment = text;
        this.lastTagSet = new LinkedList();
    }

    public void addJavaDocTag(String tag, String text, int lineNumber) {
        DocletTag docletTag = this.docletTagFactory.createDocletTag(tag, text, lineNumber);
        this.lastTagSet.add(docletTag);
    }

    public void beginClass(ClassDef def) {
        this.currentClass = new JavaClass(this.currentParent);
        this.currentClass.setName(def.name);
        this.currentClass.setInterface(def.isInterface);
        if (def.isInterface) {
            this.currentClass.setSuperClass(null);
        } else {
            this.currentClass.setSuperClass(def.extendz.size() > 0 ? this.createType((String)def.extendz.toArray()[0], 0) : null);
        }
        Set implementSet = def.isInterface ? def.extendz : def.implementz;
        Iterator implementIt = implementSet.iterator();
        Type[] implementz = new Type[implementSet.size()];
        for (int i = 0; i < implementz.length && implementIt.hasNext(); ++i) {
            implementz[i] = this.createType((String)implementIt.next(), 0);
        }
        this.currentClass.setImplementz(implementz);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        this.currentClass.setModifiers(modifiers);
        this.addJavaDoc(this.currentClass);
        this.currentParent.addClass(this.currentClass);
        this.currentParent = this.currentClass;
        this.classLibrary.add(this.currentClass.getFullyQualifiedName());
    }

    public void endClass() {
        this.currentParent = this.currentClass.getParent();
        this.currentClass = this.currentParent instanceof JavaClass ? (JavaClass)this.currentParent : null;
    }

    private Type createType(String typeName, int dimensions) {
        if (typeName == null || typeName.equals("")) {
            return null;
        }
        return Type.createUnresolved(typeName, dimensions, this.currentClass);
    }

    private void addJavaDoc(AbstractJavaEntity entity) {
        if (this.lastComment != null) {
            entity.setComment(this.lastComment);
            entity.setTags(this.lastTagSet);
        }
        this.lastComment = null;
    }

    public void addMethod(MethodDef def) {
        JavaMethod currentMethod = new JavaMethod(this.currentClass);
        currentMethod.setName(def.name);
        currentMethod.setReturns(this.createType(def.returns, def.dimensions));
        currentMethod.setConstructor(def.constructor);
        JavaParameter[] params = new JavaParameter[def.params.size()];
        int i = 0;
        Iterator iterator = def.params.iterator();
        while (iterator.hasNext()) {
            FieldDef fieldDef = (FieldDef)iterator.next();
            params[i++] = new JavaParameter(this.createType(fieldDef.type, fieldDef.dimensions), fieldDef.name);
        }
        currentMethod.setParameters(params);
        Type[] exceptions = new Type[def.exceptions.size()];
        int index = 0;
        Iterator iter = def.exceptions.iterator();
        while (iter.hasNext()) {
            exceptions[index++] = this.createType((String)iter.next(), 0);
        }
        currentMethod.setExceptions(exceptions);
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentMethod.setModifiers(modifiers);
        this.addJavaDoc(currentMethod);
        this.currentClass.addMethod(currentMethod);
    }

    public void addField(FieldDef def) {
        JavaField currentField = new JavaField(this.currentClass);
        currentField.setName(def.name);
        currentField.setType(this.createType(def.type, def.dimensions));
        String[] modifiers = new String[def.modifiers.size()];
        def.modifiers.toArray(modifiers);
        currentField.setModifiers(modifiers);
        this.addJavaDoc(currentField);
        this.currentClass.addField(currentField);
    }

    public JavaSource getSource() {
        return this.source;
    }
}

