/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.backport175.compiler.CompilerException;
import org.codehaus.backport175.compiler.MessageHandler;

public class AnnotationInterfaceRepository {
    private final Map m_aliasInterfaceMap = new HashMap();
    private final Properties m_properties = new Properties();
    private final Set m_ignoredDocletNames = new HashSet();
    private MessageHandler m_handler;

    public AnnotationInterfaceRepository(MessageHandler handler) {
        this.m_handler = handler;
    }

    private void registerAnnotationInterface(String name, Class interfaceClass) {
        if (this.m_aliasInterfaceMap.containsValue(interfaceClass)) {
            Iterator iterator = this.m_aliasInterfaceMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!entry.getValue().equals(interfaceClass)) continue;
                throw new CompilerException("unable to register [" + interfaceClass.getName() + "] as [" + name + "] since it is already registered under the name [" + entry.getKey() + ']');
            }
        }
        this.m_handler.info("register annotation [" + name + " :: " + interfaceClass + ']');
        this.m_aliasInterfaceMap.put(name, interfaceClass);
    }

    public void registerPropertiesFiles(String[] propertiesFiles, ClassLoader loader) {
        if (propertiesFiles == null) {
            return;
        }
        this.loadPropertiesFiles(propertiesFiles);
        this.loadAnnotationInterfacesDefinedInPropertiesFiles(loader);
    }

    private void loadPropertiesFiles(String[] propertiesFiles) {
        FileInputStream in = null;
        for (int i = 0; i < propertiesFiles.length; ++i) {
            String propertiesFile = propertiesFiles[i];
            try {
                in = new FileInputStream(propertiesFile);
                this.m_properties.load(in);
                continue;
            }
            catch (Exception e) {
                throw new CompilerException("annotation properties file " + propertiesFile + " can not be loaded: " + e.toString());
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void loadAnnotationInterfacesDefinedInPropertiesFiles(ClassLoader loader) {
        Iterator<Map.Entry<Object, Object>> it = this.m_properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String name = ((String)entry.getKey()).trim();
            String className = ((String)entry.getValue()).trim();
            if (className.equals("")) {
                throw new CompilerException("no annotation interface mapped to the alias [" + name + "] defined in the 'annotation.properties' file");
            }
            Class annotationInterfaceClass = AnnotationInterfaceRepository.loadClassHandlingNestedSyntax(className, loader);
            if (annotationInterfaceClass == null) {
                throw new CompilerException("[" + className + "] could not be found on system classpath or class path provided as argument to the compiler");
            }
            this.registerAnnotationInterface(name, annotationInterfaceClass);
        }
    }

    public Class getAnnotationInterfaceFor(String annotationName, ClassLoader loader) {
        Class annotationInterfaceClass;
        if (this.m_ignoredDocletNames.contains(annotationName)) {
            return null;
        }
        Object klass = this.m_aliasInterfaceMap.get(annotationName);
        if (klass != null) {
            annotationInterfaceClass = (Class)klass;
        } else {
            annotationInterfaceClass = AnnotationInterfaceRepository.loadClassHandlingNestedSyntax(annotationName, loader);
            if (annotationInterfaceClass == null) {
                this.m_ignoredDocletNames.add(annotationName);
                return null;
            }
            this.registerAnnotationInterface(annotationName, annotationInterfaceClass);
        }
        if (!annotationInterfaceClass.isInterface()) {
            throw new CompilerException("annotation class is not defined as an interface for " + annotationName);
        }
        return annotationInterfaceClass;
    }

    private static Class loadClassHandlingNestedSyntax(String className, ClassLoader loader) {
        try {
            return Class.forName(className, false, loader);
        }
        catch (Throwable e) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                char[] classNameHopes = className.toCharArray();
                classNameHopes[lastDot] = 36;
                return AnnotationInterfaceRepository.loadClassHandlingNestedSyntax(new String(classNameHopes), loader);
            }
            return null;
        }
    }

    public Set getIgnoredDocletNames() {
        return this.m_ignoredDocletNames;
    }
}

