/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler.bytecode;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaField;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaMethod;
import org.codehaus.backport175.compiler.CompilerException;
import org.codehaus.backport175.compiler.MessageHandler;
import org.codehaus.backport175.compiler.SourceLocation;
import org.codehaus.backport175.compiler.bytecode.InstrumentationException;
import org.codehaus.backport175.compiler.javadoc.RawAnnotation;
import org.codehaus.backport175.compiler.parser.AnnotationParser;
import org.codehaus.backport175.compiler.parser.ParseException;
import org.codehaus.backport175.org.objectweb.asm.AnnotationVisitor;
import org.codehaus.backport175.org.objectweb.asm.ClassAdapter;
import org.codehaus.backport175.org.objectweb.asm.ClassReader;
import org.codehaus.backport175.org.objectweb.asm.ClassVisitor;
import org.codehaus.backport175.org.objectweb.asm.ClassWriter;
import org.codehaus.backport175.org.objectweb.asm.FieldVisitor;
import org.codehaus.backport175.org.objectweb.asm.MethodVisitor;
import org.codehaus.backport175.org.objectweb.asm.Type;

public class AnnotationEnhancer {
    private ClassReader m_reader = null;
    private String m_classFileName = null;
    private String m_className = null;
    private ClassLoader m_loader = null;
    private List m_classAnnotations = new ArrayList();
    private List m_constructorAnnotations = new ArrayList();
    private List m_methodAnnotations = new ArrayList();
    private List m_fieldAnnotations = new ArrayList();
    private final MessageHandler m_messageHandler;

    public AnnotationEnhancer(MessageHandler messageHandler) {
        this.m_messageHandler = messageHandler;
    }

    public boolean initialize(String className, URL[] classPath) {
        return this.initialize(className, new URLClassLoader(classPath));
    }

    public boolean initialize(String className, ClassLoader loader) {
        try {
            this.m_className = className;
            this.m_loader = loader;
            this.m_classFileName = className.replace('.', '/') + ".class";
            InputStream classAsStream = this.m_loader.getResourceAsStream(this.m_classFileName);
            if (classAsStream == null) {
                return false;
            }
            try {
                this.m_reader = new ClassReader(classAsStream);
            }
            catch (Exception e) {
                throw new ClassNotFoundException(this.m_className, e);
            }
            finally {
                classAsStream.close();
            }
        }
        catch (Exception e) {
            throw new InstrumentationException("could not add annotations to bytecode of class [" + className + "] due to: " + e.toString(), e);
        }
        return true;
    }

    public void insertClassAnnotation(RawAnnotation annotation) {
        if (this.m_reader == null) {
            throw new IllegalStateException("annotation enhancer is not initialized");
        }
        if (this.hasClassAnnotation(annotation)) {
            throw new CompilerException("duplicate class annotation " + annotation, SourceLocation.render(annotation));
        }
        this.m_classAnnotations.add(annotation);
    }

    public void insertFieldAnnotation(JavaField field, RawAnnotation annotation) {
        if (this.m_reader == null) {
            throw new IllegalStateException("annotation enhancer is not initialized");
        }
        FieldAnnotationInfo info = new FieldAnnotationInfo(field, annotation);
        if (this.hasFieldAnnotation(info)) {
            throw new CompilerException("duplicate field annotation " + annotation, SourceLocation.render(annotation));
        }
        this.m_fieldAnnotations.add(new FieldAnnotationInfo(field, annotation));
    }

    public void insertMethodAnnotation(JavaMethod method, RawAnnotation annotation) {
        if (this.m_reader == null) {
            throw new IllegalStateException("annotation enhancer is not initialized");
        }
        MethodAnnotationInfo info = new MethodAnnotationInfo(method, annotation);
        if (this.hasMethodAnnotation(info)) {
            throw new ParseException("duplicate method annotation " + annotation, SourceLocation.render(annotation));
        }
        this.m_methodAnnotations.add(new MethodAnnotationInfo(method, annotation));
    }

    public void insertConstructorAnnotation(JavaMethod constructor, RawAnnotation annotation) {
        if (this.m_reader == null) {
            throw new IllegalStateException("annotation enhancer is not initialized");
        }
        MethodAnnotationInfo info = new MethodAnnotationInfo(constructor, annotation);
        if (this.hasConstructorAnnotation(info)) {
            throw new CompilerException("duplicate constructor annotation " + annotation, SourceLocation.render(annotation));
        }
        this.m_constructorAnnotations.add(new MethodAnnotationInfo(constructor, annotation));
    }

    public void write(String destDir) {
        if (this.m_reader == null) {
            throw new IllegalStateException("annotation enhancer is not initialized");
        }
        ClassWriter writer = new ClassWriter(true);
        this.m_reader.accept(new AnnotationMungingVisitor(writer), false);
        String filename = destDir + File.separator + this.m_classFileName;
        File file = new File(filename);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new CompilerException("could not create dir structure needed to write file " + filename + " to disk");
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(filename);
            os.write(writer.toByteArray());
        }
        catch (IOException e) {
            throw new CompilerException("could not write compiled class file to disk [" + filename + "]", e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new CompilerException("could not close file output stream for [" + filename + "]", e);
            }
        }
    }

    public static String getFieldDesc(JavaField field) {
        return AnnotationEnhancer.getDescForQDoxType(field.getType());
    }

    public static String getMethodDesc(JavaMethod method) {
        StringBuffer sig = new StringBuffer();
        sig.append('(');
        String[] methodParamTypes = new String[method.getParameters().length];
        for (int i = 0; i < methodParamTypes.length; ++i) {
            sig.append(AnnotationEnhancer.getDescForQDoxType(method.getParameters()[i].getType()));
        }
        sig.append(')');
        org.codehaus.backport175.com.thoughtworks.qdox.model.Type returns = method.getReturns();
        sig.append(AnnotationEnhancer.getDescForQDoxType(returns));
        return sig.toString();
    }

    public static String getDescForQDoxType(org.codehaus.backport175.com.thoughtworks.qdox.model.Type type) {
        String value;
        if (type == null) {
            return "V";
        }
        StringBuffer desc = new StringBuffer();
        if (type.isArray()) {
            for (int i = type.getDimensions(); i > 0; --i) {
                desc.append('[');
            }
        }
        if ((value = type.getValue()).equals("void")) {
            desc.append("V");
        } else if (value.equals("int")) {
            desc.append("I");
        } else if (value.equals("long")) {
            desc.append("J");
        } else if (value.equals("short")) {
            desc.append("S");
        } else if (value.equals("float")) {
            desc.append("F");
        } else if (value.equals("double")) {
            desc.append("D");
        } else if (value.equals("boolean")) {
            desc.append("Z");
        } else if (value.equals("char")) {
            desc.append("C");
        } else if (value.equals("byte")) {
            desc.append("B");
        } else {
            desc.append('L').append(value.replace('.', '/')).append(';');
        }
        return desc.toString();
    }

    private boolean hasClassAnnotation(RawAnnotation annotation) {
        return this.m_classAnnotations.contains(annotation);
    }

    private boolean hasMethodAnnotation(MethodAnnotationInfo annotation) {
        return this.m_methodAnnotations.contains(annotation);
    }

    private boolean hasFieldAnnotation(FieldAnnotationInfo annotation) {
        return this.m_fieldAnnotations.contains(annotation);
    }

    private boolean hasConstructorAnnotation(MethodAnnotationInfo annotation) {
        return this.m_constructorAnnotations.contains(annotation);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getClassFileName() {
        return this.m_classFileName;
    }

    public ClassLoader getClassLoader() {
        return this.m_loader;
    }

    private static class MethodAnnotationInfo {
        public final RawAnnotation annotation;
        public final JavaMethod method;

        public MethodAnnotationInfo(JavaMethod method, RawAnnotation attribute) {
            this.method = method;
            this.annotation = attribute;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodAnnotationInfo)) {
                return false;
            }
            MethodAnnotationInfo methodAnnotationInfo = (MethodAnnotationInfo)o;
            if (!this.annotation.equals(methodAnnotationInfo.annotation)) {
                return false;
            }
            return this.method.equals(methodAnnotationInfo.method);
        }

        public int hashCode() {
            int result = this.annotation.hashCode();
            result = 29 * result + this.method.hashCode();
            return result;
        }
    }

    private static class FieldAnnotationInfo {
        public final RawAnnotation annotation;
        public final JavaField field;

        public FieldAnnotationInfo(JavaField field, RawAnnotation attribute) {
            this.field = field;
            this.annotation = attribute;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldAnnotationInfo)) {
                return false;
            }
            FieldAnnotationInfo fieldAnnotationInfo = (FieldAnnotationInfo)o;
            if (!this.annotation.equals(fieldAnnotationInfo.annotation)) {
                return false;
            }
            return this.field.equals(fieldAnnotationInfo.field);
        }

        public int hashCode() {
            int result = this.annotation.hashCode();
            result = 29 * result + this.field.hashCode();
            return result;
        }
    }

    private class AnnotationMungingVisitor
    extends ClassAdapter {
        private static final String INIT_METHOD_NAME = "<init>";

        public AnnotationMungingVisitor(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            boolean hasRetention = false;
            Iterator iterator = AnnotationEnhancer.this.m_classAnnotations.iterator();
            while (iterator.hasNext()) {
                RawAnnotation rawAnnotation = (RawAnnotation)iterator.next();
                if (!rawAnnotation.getName().equals("java.lang.annotation.Retention")) continue;
                hasRetention = true;
                break;
            }
            if (hasRetention) {
                access |= 0x2000;
                interfaces = new String[]{"java/lang/annotation/Annotation"};
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor fieldVisitor = super.visitField(access, name, desc, signature, value);
            Iterator it = AnnotationEnhancer.this.m_fieldAnnotations.iterator();
            while (it.hasNext()) {
                FieldAnnotationInfo annotationInfo = (FieldAnnotationInfo)it.next();
                String fieldDesc = AnnotationEnhancer.getFieldDesc(annotationInfo.field);
                if (!annotationInfo.field.getName().equals(name) || !fieldDesc.equals(desc)) continue;
                AnnotationVisitor bytecodeMunger = fieldVisitor.visitAnnotation(Type.getDescriptor(annotationInfo.annotation.getAnnotationClass()), true);
                AnnotationParser.parse(bytecodeMunger, annotationInfo.annotation);
                bytecodeMunger.visitEnd();
                AnnotationEnhancer.this.m_messageHandler.accept(SourceLocation.render(annotationInfo.annotation));
            }
            return fieldVisitor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals(INIT_METHOD_NAME)) {
                Iterator it = AnnotationEnhancer.this.m_constructorAnnotations.iterator();
                while (it.hasNext()) {
                    MethodAnnotationInfo annotationInfo = (MethodAnnotationInfo)it.next();
                    if (!AnnotationEnhancer.getMethodDesc(annotationInfo.method).equals(desc)) continue;
                    AnnotationVisitor bytecodeMunger = methodVisitor.visitAnnotation(Type.getDescriptor(annotationInfo.annotation.getAnnotationClass()), true);
                    AnnotationParser.parse(bytecodeMunger, annotationInfo.annotation);
                    bytecodeMunger.visitEnd();
                    AnnotationEnhancer.this.m_messageHandler.accept(SourceLocation.render(annotationInfo.annotation));
                }
            } else {
                Iterator it = AnnotationEnhancer.this.m_methodAnnotations.iterator();
                while (it.hasNext()) {
                    AnnotationVisitor bytecodeMunger;
                    MethodAnnotationInfo annotationInfo = (MethodAnnotationInfo)it.next();
                    if (!annotationInfo.method.getName().equals(name) || !AnnotationEnhancer.getMethodDesc(annotationInfo.method).equals(desc)) continue;
                    if (annotationInfo.annotation.isAnnotationDefaultValue()) {
                        bytecodeMunger = methodVisitor.visitAnnotationDefault();
                        AnnotationParser.parse(bytecodeMunger, annotationInfo.annotation, Type.getReturnType(desc).getDescriptor());
                    } else {
                        bytecodeMunger = methodVisitor.visitAnnotation(Type.getDescriptor(annotationInfo.annotation.getAnnotationClass()), true);
                        AnnotationParser.parse(bytecodeMunger, annotationInfo.annotation);
                    }
                    bytecodeMunger.visitEnd();
                    AnnotationEnhancer.this.m_messageHandler.accept(SourceLocation.render(annotationInfo.annotation));
                }
            }
            return methodVisitor;
        }

        public void visitEnd() {
            Iterator it = AnnotationEnhancer.this.m_classAnnotations.iterator();
            while (it.hasNext()) {
                RawAnnotation rawAnnotation = (RawAnnotation)it.next();
                AnnotationVisitor bytecodeMunger = this.visitAnnotation(Type.getDescriptor(rawAnnotation.getAnnotationClass()), true);
                AnnotationParser.parse(bytecodeMunger, rawAnnotation);
                bytecodeMunger.visitEnd();
                AnnotationEnhancer.this.m_messageHandler.accept(SourceLocation.render(rawAnnotation));
            }
            super.visitEnd();
        }
    }
}

