/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.backport175.com.thoughtworks.qdox.JavaDocBuilder;
import org.codehaus.backport175.com.thoughtworks.qdox.model.DocletTag;
import org.codehaus.backport175.com.thoughtworks.qdox.model.JavaClass;
import org.codehaus.backport175.compiler.CompilerException;
import org.codehaus.backport175.compiler.SourceLocation;
import org.codehaus.backport175.compiler.javadoc.RawAnnotation;
import org.codehaus.backport175.compiler.javadoc.SourceParseException;

public class JavaDocParser {
    private static final String JAVA_LANG_OBJECT_CLASS_NAME = "java.lang.Object";
    private final JavaDocBuilder m_javaDocParser = new JavaDocBuilder();

    public void addClassLoaderToSearchPath(ClassLoader loader) {
        this.m_javaDocParser.getClassLibrary().addClassLoader(loader);
    }

    public void addSourceTrees(String[] srcDirs) {
        for (int i = 0; i < srcDirs.length; ++i) {
            try {
                this.m_javaDocParser.addSourceTree(new File(srcDirs[i]));
                continue;
            }
            catch (Exception e) {
                throw new SourceParseException("source file in source tree [" + srcDirs[i] + "] could not be parsed due to: " + e.toString(), e);
            }
        }
    }

    public void addSource(String srcFile) {
        try {
            this.m_javaDocParser.addSource(new File(srcFile));
        }
        catch (Exception e) {
            throw new SourceParseException("source file [" + srcFile + "] could not be parsed due to: " + e.toString(), e);
        }
    }

    public JavaClass[] getJavaClasses() {
        Collection classes = this.m_javaDocParser.getClassLibrary().all();
        ArrayList<JavaClass> javaClasses = new ArrayList<JavaClass>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            if (JAVA_LANG_OBJECT_CLASS_NAME.equals(className)) continue;
            JavaClass clazz = this.m_javaDocParser.getClassByName(className);
            javaClasses.add(clazz);
        }
        return javaClasses.toArray(new JavaClass[0]);
    }

    public static RawAnnotation getRawAnnotation(Class annotationClass, String annotationName, DocletTag tag, String enclosingClassName, String enclosingClassFileName) {
        String rawAnnotationString = tag.getName() + " " + tag.getValue();
        rawAnnotationString = rawAnnotationString.trim();
        JavaDocParser.removeFormattingCharacters(rawAnnotationString);
        if (rawAnnotationString.length() > annotationName.length()) {
            String rawValueString = rawAnnotationString.substring(annotationName.length());
            char first = (rawValueString = rawValueString.trim()).charAt(0);
            if (first == '(') {
                if (!rawValueString.endsWith(")")) {
                    throw new CompilerException("annotation not well-formed, needs to end with a closing parenthesis [" + rawAnnotationString + "]", SourceLocation.render(annotationClass, tag, enclosingClassName, enclosingClassFileName));
                }
                return new RawAnnotation(annotationClass, rawValueString.substring(1, rawValueString.length() - 1), tag.getLineNumber(), enclosingClassName, enclosingClassFileName);
            }
            if (first == '\"') {
                if (!rawValueString.endsWith("\"")) {
                    throw new CompilerException("annotation not well-formed, needs to end with a closing \" [" + rawAnnotationString + "]", SourceLocation.render(annotationClass, tag, enclosingClassName, enclosingClassFileName));
                }
                return new RawAnnotation(annotationClass, rawValueString, tag.getLineNumber(), enclosingClassName, enclosingClassFileName);
            }
            StringBuffer sb = new StringBuffer("\"");
            for (int i = 0; i < rawValueString.length(); ++i) {
                char c = rawValueString.charAt(i);
                if (c == '\"') {
                    sb.append("\\\"");
                    continue;
                }
                sb.append(c);
            }
            sb.append("\"");
            return new RawAnnotation(annotationClass, sb.toString(), tag.getLineNumber(), enclosingClassName, enclosingClassFileName);
        }
        return new RawAnnotation(annotationClass, "", tag.getLineNumber(), enclosingClassName, enclosingClassFileName);
    }

    private static String removeFormattingCharacters(String toBeEscaped) {
        StringBuffer escapedBuffer = new StringBuffer();
        for (int i = 0; i < toBeEscaped.length(); ++i) {
            if (toBeEscaped.charAt(i) == '\n' || toBeEscaped.charAt(i) == '\r' || toBeEscaped.charAt(i) == '\t') continue;
            escapedBuffer.append(toBeEscaped.charAt(i));
        }
        return escapedBuffer.toString();
    }
}

