/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.reader.bytecode;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.backport175.org.objectweb.asm.AnnotationVisitor;
import org.codehaus.backport175.org.objectweb.asm.ClassAdapter;
import org.codehaus.backport175.org.objectweb.asm.ClassReader;
import org.codehaus.backport175.org.objectweb.asm.ClassWriter;
import org.codehaus.backport175.org.objectweb.asm.MethodAdapter;
import org.codehaus.backport175.org.objectweb.asm.MethodVisitor;
import org.codehaus.backport175.reader.ReaderException;
import org.codehaus.backport175.reader.bytecode.AnnotationElement;
import org.codehaus.backport175.reader.bytecode.AnnotationReader;

class AnnotationDefaults {
    private static Map s_annotationDefaults = new HashMap();

    AnnotationDefaults() {
    }

    public static AnnotationElement.Annotation getDefaults(String annotationClassName, final ClassLoader loader) {
        AnnotationReader.ClassKey key = new AnnotationReader.ClassKey(annotationClassName, loader);
        AnnotationElement.Annotation defaults = (AnnotationElement.Annotation)s_annotationDefaults.get(key);
        if (defaults == null) {
            byte[] bytes;
            final AnnotationElement.Annotation newDefaults = new AnnotationElement.Annotation(annotationClassName);
            try {
                bytes = AnnotationReader.getBytecodeFor(annotationClassName, loader);
            }
            catch (Exception e) {
                throw new ReaderException("could not retrieve the bytecode from the bytecode provider for class [" + annotationClassName + "]", e);
            }
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(false, true);
            cr.accept(new ClassAdapter(cw){

                public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
                    return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                        public AnnotationVisitor visitAnnotationDefault() {
                            return new DefaultAnnotationBuilderVisitor((AnnotationElement.NestedAnnotationElement)newDefaults, name, loader);
                        }
                    };
                }
            }, true);
            defaults = newDefaults;
            s_annotationDefaults.put(key, newDefaults);
        }
        return defaults;
    }

    public static void refresh(AnnotationReader.ClassKey key) {
        AnnotationElement.Annotation defaults = (AnnotationElement.Annotation)s_annotationDefaults.get(key);
        if (defaults != null) {
            s_annotationDefaults.remove(key);
        }
    }

    static class DefaultAnnotationBuilderVisitor
    extends AnnotationReader.AnnotationBuilderVisitor {
        private String m_methodName;

        public DefaultAnnotationBuilderVisitor(AnnotationElement.NestedAnnotationElement annotation, String methodName, ClassLoader loader) {
            super(annotation, loader, null);
            this.m_methodName = methodName;
        }

        public void visit(String name, Object value) {
            super.visit(this.m_methodName, value);
        }

        public void visitEnum(String name, String desc, String value) {
            super.visitEnum(this.m_methodName, desc, value);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return super.visitAnnotation(this.m_methodName, desc);
        }

        public AnnotationVisitor visitArray(String name) {
            return super.visitArray(this.m_methodName);
        }
    }
}

