/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.DumpingFiler;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.Filer;
import org.multiverse.instrumentation.InstrumentationPhase;
import org.multiverse.instrumentation.InstrumenterLogger;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.NullInstrumenterLogger;
import org.multiverse.instrumentation.Resolver;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.MetadataRepository;

public class StandardInstrumentor
implements Instrumentor {
    private final MetadataRepository metadataRepository = new MetadataRepository();
    private final List<InstrumentationPhase> phases = new LinkedList<InstrumentationPhase>();
    private final String compilerName;
    private final String compilerVersion;
    private Resolver resolver;
    private Filer filer;
    private boolean dumpBytecode;
    private File dumpDir = new File(System.getProperty("java.io.tmpdir"));
    private InstrumenterLogger log = new NullInstrumenterLogger();
    private final String stmName;
    private boolean optimize = false;

    public StandardInstrumentor(String compilerName, String compilerVersion, String stmName) {
        if (compilerName == null || compilerVersion == null || stmName == null) {
            throw new NullPointerException();
        }
        this.compilerName = compilerName;
        this.compilerVersion = compilerVersion;
        this.stmName = stmName;
    }

    protected final void add(InstrumentationPhase phase) {
        if (this.phases == null) {
            throw new NullPointerException();
        }
        this.phases.add(phase);
    }

    @Override
    public String getInstrumentorName() {
        return this.compilerName;
    }

    @Override
    public String getInstrumentorVersion() {
        return this.compilerVersion;
    }

    @Override
    public String getStmName() {
        return this.stmName;
    }

    @Override
    public void addExcluded(String ignored) {
    }

    @Override
    public void addIncluded(String included) {
    }

    @Override
    public void setLog(InstrumenterLogger log) {
        this.log = log == null ? new NullInstrumenterLogger() : log;
    }

    @Override
    public void setDumpBytecode(boolean dumpBytecode) {
        this.dumpBytecode = dumpBytecode;
    }

    @Override
    public void setDumpDirectory(File dumpDirectory) {
        if (dumpDirectory == null) {
            throw new NullPointerException();
        }
        this.dumpDir = dumpDirectory;
    }

    @Override
    public File getDumpDirectory() {
        return this.dumpDir;
    }

    @Override
    public void setFiler(Filer filer) {
        if (filer == null) {
            throw new NullPointerException();
        }
        this.filer = filer;
    }

    @Override
    public void setResolver(Resolver resolver) {
        if (resolver == null) {
            throw new NullPointerException();
        }
        this.resolver = resolver;
    }

    @Override
    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    @Override
    public Clazz process(Clazz originalClazz) {
        InstrumentationPhase phase;
        Clazz afterClazz;
        if (originalClazz.getClassLoader() == null) {
            this.log.important("Multiverse: Ignoring class '%s' because it is a system class", originalClazz.getName());
            return originalClazz;
        }
        if (StandardInstrumentor.isExcluded(originalClazz.getName())) {
            this.log.important("Multiverse: Ignoring class '%s' because it is excluded", originalClazz.getName());
            return originalClazz;
        }
        this.log.important("Multiverse: instrumenting %s", originalClazz.getName());
        EnvironmentImpl env = new EnvironmentImpl();
        Clazz beforeClazz = originalClazz;
        Iterator<InstrumentationPhase> i$ = this.phases.iterator();
        while (i$.hasNext() && (afterClazz = (phase = i$.next()).instrument(env, beforeClazz)) != null) {
            this.dump(phase, beforeClazz, afterClazz);
            beforeClazz = afterClazz;
        }
        if (originalClazz == beforeClazz) {
            this.log.lessImportant("Multiverse: Finished compilation of class '%s' (class was not modified)", originalClazz.getName());
        } else {
            this.log.lessImportant("Multiverse: Finished compilation of class '%s'", originalClazz.getName());
        }
        return beforeClazz;
    }

    private void dump(InstrumentationPhase step, Clazz beforeClazz, Clazz afterClazz) {
        if (!this.dumpBytecode || afterClazz == beforeClazz) {
            return;
        }
        File begin = new File(this.dumpDir, beforeClazz.getName() + "_" + step.getName() + "_before.class");
        AsmUtils.writeToFile(begin, beforeClazz.getBytecode());
        File end = new File(this.dumpDir, beforeClazz.getName() + "_" + step.getName() + "_after.class");
        AsmUtils.writeToFile(end, afterClazz.getBytecode());
    }

    private static boolean isExcluded(String className) {
        return className.startsWith("java/") || className.startsWith("javax/") || className.startsWith("com/ibm/") || className.startsWith("org/mockito") || className.startsWith("org/gradle") || className.startsWith("ch/qos") || className.startsWith("com/jprofiler/") || className.startsWith("org/junit") || className.startsWith("sun/") || className.startsWith("com/sun") || className.startsWith("org/apache/") || className.startsWith("org/jruby/") || className.startsWith("org/slf4j/") || className.startsWith("org/hamcrest/") || className.startsWith("com/intellij") || className.startsWith("org/eclipse") || className.startsWith("org/kohsuke/args4j") || className.startsWith("org/objectweb/asm") || className.startsWith("org/multiverse/repackaged") || className.startsWith("junit/");
    }

    public String toString() {
        return this.compilerName + "-" + this.compilerVersion;
    }

    class EnvironmentImpl
    implements Environment {
        EnvironmentImpl() {
        }

        @Override
        public boolean optimize() {
            return StandardInstrumentor.this.optimize;
        }

        @Override
        public boolean dumpBytecode() {
            return StandardInstrumentor.this.dumpBytecode;
        }

        @Override
        public Filer getFiler() {
            if (StandardInstrumentor.this.dumpBytecode) {
                return new DumpingFiler(StandardInstrumentor.this.filer, StandardInstrumentor.this.dumpDir);
            }
            return StandardInstrumentor.this.filer;
        }

        @Override
        public InstrumenterLogger getLog() {
            return StandardInstrumentor.this.log;
        }

        @Override
        public File getDumpDirectory() {
            return StandardInstrumentor.this.dumpDir;
        }

        @Override
        public MetadataRepository getMetadataRepository() {
            return StandardInstrumentor.this.metadataRepository;
        }
    }
}

