/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.metadata;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.multiverse.instrumentation.asm.AsmClassMetadataExtractor;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.ClassMetadataExtractor;
import org.multiverse.instrumentation.metadata.Multikey;
import org.objectweb.asm.Type;

public final class MetadataRepository {
    private final ConcurrentMap<Multikey, ClassMetadata> map = new ConcurrentHashMap<Multikey, ClassMetadata>();
    private final ClassMetadataExtractor extractor;

    public MetadataRepository() {
        this(new AsmClassMetadataExtractor());
    }

    public MetadataRepository(ClassMetadataExtractor extractor) {
        if (extractor == null) {
            throw new NullPointerException();
        }
        this.extractor = extractor;
        this.extractor.init(this);
    }

    public ClassMetadata loadClassMetadata(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        String name = Type.getInternalName((Class)clazz);
        return this.loadClassMetadata(clazz.getClassLoader(), name);
    }

    public ClassMetadata loadClassMetadata(ClassLoader classLoader, String className) {
        if (className == null) {
            throw new NullPointerException();
        }
        Multikey key = new Multikey(classLoader, className);
        ClassMetadata classMetadata = (ClassMetadata)this.map.get(key);
        if (classMetadata == null) {
            classMetadata = this.extractor.extract(className, classLoader);
            this.map.put(key, classMetadata);
        }
        return classMetadata;
    }
}

