/*
 * Decompiled with CFR 0.152.
 */
package jsr166x;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import jsr166x.ConcurrentSkipListMap;
import jsr166x.NavigableSet;

public class ConcurrentSkipListSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentSkipListMap<E, Object> m;

    public ConcurrentSkipListSet() {
        this.m = new ConcurrentSkipListMap();
    }

    public ConcurrentSkipListSet(Comparator<? super E> c) {
        this.m = new ConcurrentSkipListMap(c);
    }

    public ConcurrentSkipListSet(Collection<? extends E> c) {
        this.m = new ConcurrentSkipListMap();
        this.addAll(c);
    }

    public ConcurrentSkipListSet(SortedSet<E> s) {
        this.m = new ConcurrentSkipListMap(s.comparator());
        this.addAll(s);
    }

    public Object clone() {
        ConcurrentSkipListSet clone = null;
        try {
            clone = (ConcurrentSkipListSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.m.initialize();
        clone.addAll(this);
        return clone;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.m.putIfAbsent(o, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.m.removep(o);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.keyIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeyIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        try {
            return this.containsAll(c) && c.containsAll(this);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            if (!this.remove(i.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public E ceiling(E o) {
        return this.m.ceilingKey(o);
    }

    @Override
    public E lower(E o) {
        return this.m.lowerKey(o);
    }

    @Override
    public E floor(E o) {
        return this.m.floorKey(o);
    }

    @Override
    public E higher(E o) {
        return this.m.higherKey(o);
    }

    @Override
    public E pollFirst() {
        return this.m.pollFirstKey();
    }

    @Override
    public E pollLast() {
        return this.m.pollLastKey();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return this.m.firstKey();
    }

    @Override
    public E last() {
        return this.m.lastKey();
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, E toElement) {
        return new ConcurrentSkipListSubSet<E>(this.m, fromElement, toElement);
    }

    @Override
    public NavigableSet<E> headSet(E toElement) {
        return new ConcurrentSkipListSubSet<Object>((ConcurrentSkipListMap<Object, Object>)this.m, null, toElement);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement) {
        return new ConcurrentSkipListSubSet<Object>((ConcurrentSkipListMap<Object, Object>)this.m, fromElement, null);
    }

    static class ConcurrentSkipListSubSet<E>
    extends AbstractSet<E>
    implements NavigableSet<E>,
    Serializable {
        private static final long serialVersionUID = -7647078645896651609L;
        private final ConcurrentSkipListMap.ConcurrentSkipListSubMap<E, Object> s;

        ConcurrentSkipListSubSet(ConcurrentSkipListMap<E, Object> map, E fromElement, E toElement) {
            this.s = new ConcurrentSkipListMap.ConcurrentSkipListSubMap<E, Object>(map, fromElement, toElement);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, E toElement) {
            if (!this.s.inOpenRange(fromElement) || !this.s.inOpenRange(toElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet<E>(this.s.getMap(), fromElement, toElement);
        }

        @Override
        public NavigableSet<E> headSet(E toElement) {
            E least = this.s.getLeast();
            if (!this.s.inOpenRange(toElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet<E>(this.s.getMap(), least, toElement);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement) {
            E fence = this.s.getFence();
            if (!this.s.inOpenRange(fromElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet<E>(this.s.getMap(), fromElement, fence);
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.s.containsKey(o);
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public E first() {
            return this.s.firstKey();
        }

        @Override
        public E last() {
            return this.s.lastKey();
        }

        @Override
        public E ceiling(E o) {
            return this.s.ceilingKey(o);
        }

        @Override
        public E lower(E o) {
            return this.s.lowerKey(o);
        }

        @Override
        public E floor(E o) {
            return this.s.floorKey(o);
        }

        @Override
        public E higher(E o) {
            return this.s.higherKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.s.remove(o) == Boolean.TRUE;
        }

        @Override
        public boolean add(E o) {
            return this.s.put(o, Boolean.TRUE) == null;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.s.comparator();
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.keySet().iterator();
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.s.descendingKeySet().iterator();
        }

        @Override
        public E pollFirst() {
            Map.Entry<E, Object> e = this.s.pollFirstEntry();
            return e == null ? null : (E)e.getKey();
        }

        @Override
        public E pollLast() {
            Map.Entry<E, Object> e = this.s.pollLastEntry();
            return e == null ? null : (E)e.getKey();
        }
    }
}

