/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.example.http.snoop;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.util.CharsetUtil;

public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder buf = new StringBuilder();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            HttpRequest request = this.request = (HttpRequest)e.getMessage();
            this.buf.setLength(0);
            this.buf.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.buf.append("===================================\r\n");
            this.buf.append("VERSION: " + request.getProtocolVersion() + "\r\n");
            this.buf.append("HOSTNAME: " + HttpHeaders.getHost(request, "unknown") + "\r\n");
            this.buf.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            for (Map.Entry<String, String> h : request.getHeaders()) {
                this.buf.append("HEADER: " + h.getKey() + " = " + h.getValue() + "\r\n");
            }
            this.buf.append("\r\n");
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
            Map<String, List<String>> params = queryStringDecoder.getParameters();
            if (!params.isEmpty()) {
                for (Map.Entry<String, List<String>> p : params.entrySet()) {
                    String key = p.getKey();
                    List<String> vals = p.getValue();
                    for (String val : vals) {
                        this.buf.append("PARAM: " + key + " = " + val + "\r\n");
                    }
                }
                this.buf.append("\r\n");
            }
            if (request.isChunked()) {
                this.readingChunks = true;
            } else {
                ChannelBuffer content = request.getContent();
                if (content.readable()) {
                    this.buf.append("CONTENT: " + content.toString(CharsetUtil.UTF_8) + "\r\n");
                }
                this.writeResponse(e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                this.buf.append("END OF CONTENT\r\n");
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                if (!trailer.getHeaderNames().isEmpty()) {
                    this.buf.append("\r\n");
                    for (String name : trailer.getHeaderNames()) {
                        for (String value : trailer.getHeaders(name)) {
                            this.buf.append("TRAILING HEADER: " + name + " = " + value + "\r\n");
                        }
                    }
                    this.buf.append("\r\n");
                }
                this.writeResponse(e);
            } else {
                this.buf.append("CHUNK: " + chunk.getContent().toString(CharsetUtil.UTF_8) + "\r\n");
            }
        }
    }

    private void writeResponse(MessageEvent e) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        String cookieString;
        boolean keepAlive = HttpHeaders.isKeepAlive(this.request);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)this.buf.toString(), CharsetUtil.UTF_8));
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (keepAlive) {
            response.setHeader("Content-Length", response.getContent().readableBytes());
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        ChannelFuture future = e.getChannel().write(response);
        System.out.println(((Object)response).toString());
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }
}

