/*
 * Decompiled with CFR 0.152.
 */
package play.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayConfigurationLoadTask {
    private Project project;
    private String playId = "";
    private String prefix = "application.conf.";
    private String modulesClasspath = "modules.classpath";
    private File applicationDir;

    public void setProject(Project project) {
        this.project = project;
    }

    public void setPlayId(String playId) {
        this.playId = playId;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setApplicationDir(File applicationDir) {
        this.applicationDir = applicationDir;
    }

    public void execute() {
        if (this.applicationDir == null) {
            throw new BuildException("No applicationDir set!");
        }
        File srcFile = new File(this.applicationDir, "conf/application.conf");
        if (!srcFile.exists()) {
            throw new BuildException("No application configuration found! " + srcFile.getAbsolutePath());
        }
        Map<String, String> map = this.loadAndResolve(srcFile, this.playId);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = this.project.replaceProperties(entry.getValue());
            this.project.setProperty(this.prefix + key, value);
            this.project.log("Loaded property '" + this.prefix + key + "'='" + value + "'", 3);
        }
        File applicationDir = srcFile.getParentFile().getParentFile();
        Path path = new Path(this.project);
        FilenameSelector endsToJar = new FilenameSelector();
        endsToJar.setName("*.jar");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("module.")) continue;
            String s = entry.getValue();
            File moduleDir = !FileUtils.isAbsolutePath((String)(s = this.project.replaceProperties(s))) ? new File(applicationDir, s) : new File(s);
            if (!moduleDir.exists()) {
                this.project.log("Failed add non existing module to classpath! " + moduleDir.getAbsolutePath(), 1);
                continue;
            }
            File moduleLib = new File(moduleDir, "lib");
            if (moduleLib.exists()) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(moduleLib);
                fileSet.addFilename(endsToJar);
                path.addFileset(fileSet);
                this.project.log("Added fileSet to path: " + fileSet, 3);
                continue;
            }
            this.project.log("Ignoring non existing lib dir: " + moduleLib.getAbsolutePath(), 3);
        }
        this.project.addReference(this.modulesClasspath, (Object)path);
        this.project.log("Generated classpath '" + this.modulesClasspath + "':" + this.project.getReference(this.modulesClasspath), 3);
    }

    public Map<String, String> loadAndResolve(File srcFile, String playId) {
        try {
            String line;
            HashMap<String, String> defaults = new HashMap<String, String>();
            HashMap<String, String> idSpecific = new HashMap<String, String>();
            BufferedReader reader = new BufferedReader(new FileReader(srcFile));
            while ((line = reader.readLine()) != null) {
                String[] sa;
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("%")) {
                    if (playId.length() <= 0 || !line.startsWith("%" + playId + ".") || (sa = PlayConfigurationLoadTask.splitLine(line = line.substring(("%" + playId + ".").length()))) == null) continue;
                    idSpecific.put(sa[0], sa[1]);
                    continue;
                }
                sa = PlayConfigurationLoadTask.splitLine(line);
                if (sa == null) continue;
                defaults.put(sa[0], sa[1]);
            }
            defaults.putAll(idSpecific);
            return defaults;
        }
        catch (IOException e) {
            throw new BuildException("Failed to load configuration file: " + srcFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static String[] splitLine(String line) {
        int i = line.indexOf("=");
        if (i > 0) {
            String key = line.substring(0, i);
            String value = "";
            if (i < line.length()) {
                value = line.substring(i + 1);
            }
            return new String[]{key.trim(), value.trim()};
        }
        return null;
    }
}

