/*
 * Decompiled with CFR 0.152.
 */
package play.modules.associations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.FieldInfo;
import play.Logger;
import play.classloading.ApplicationClasses;
import play.classloading.enhancers.Enhancer;
import play.exceptions.UnexpectedException;
import play.modules.associations.AssociativeList;
import play.modules.associations.AssociativeSet;
import play.modules.associations.Reference;

public class AssociationsEnhancer
extends Enhancer {
    private static final String JAVAX_PERSISTENCE_ENTITY = "javax.persistence.Entity";
    private static final String ENHANCER_NAME = AssociationsEnhancer.class.getName();
    private static final Pattern INFO_REGEX = Pattern.compile("Ljava/util/(List|Set)<L([^;]+);>;");
    private static final Pattern COLLECTION_REGEX = Pattern.compile("^java\\.util\\.(List|Set)$");

    public void enhanceThisClass(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        CtClass ctClass = this.makeClass(applicationClass);
        if (!this.hasAnnotation(ctClass, JAVAX_PERSISTENCE_ENTITY)) {
            return;
        }
        CtField[] declaredFields = ctClass.getDeclaredFields();
        ArrayList declared = new ArrayList(declaredFields.length);
        for (CtField ctField : declaredFields) {
            try {
                AssociationProperty ap;
                if (!this.isProperty(ctField) || (ap = this.analyze(ctField)) == null) continue;
                if (Logger.isDebugEnabled()) {
                    Logger.debug((String)(ENHANCER_NAME + " found bi-directional association %s <-> %s"), (Object[])new Object[]{ap, ap.opposite});
                }
                String propertyName = ctField.getName().substring(0, 1).toUpperCase() + (ctField.getName().length() > 1 ? ctField.getName().substring(1) : "");
                String getter = "get" + propertyName;
                String setter = "set" + propertyName;
                try {
                    CtMethod ctMethodSet = ctClass.getDeclaredMethod(setter);
                    if (!ap.many) {
                        ctClass.removeMethod(ctMethodSet);
                        if (Logger.isTraceEnabled()) {
                            Logger.trace((String)("removed current " + ctMethodSet), (Object[])new Object[0]);
                        }
                    }
                }
                catch (NotFoundException noSetter) {
                    // empty catch block
                }
                try {
                    CtMethod ctMethodGet = ctClass.getDeclaredMethod(getter);
                    if (ap.many) {
                        ctClass.removeMethod(ctMethodGet);
                        if (Logger.isTraceEnabled()) {
                            Logger.trace((String)("removed current " + ctMethodGet), (Object[])new Object[0]);
                        }
                    }
                }
                catch (NotFoundException noGetter) {
                    // empty catch block
                }
                CtField reference = CtField.make((String)("public static " + Reference.class.getName() + " _ref_" + ctField.getName() + " = new " + Reference.class.getName() + "(" + ctClass.getName() + ".class, " + AssociationsEnhancer.qq(ctField.getName()) + ", " + ap.oppField.getDeclaringClass().getName() + ".class, " + AssociationsEnhancer.qq(ap.oppField.getName()) + ");"), (CtClass)ctClass);
                ctClass.addField(reference);
                if (Logger.isTraceEnabled()) {
                    Logger.trace((String)"%s added field %s", (Object[])new Object[]{ctClass.getName(), reference});
                }
                if (ap.many) {
                    Class collectionClass = ap.list ? AssociativeList.class : AssociativeSet.class;
                    CtField delegate = CtField.make((String)("public final transient " + collectionClass.getName() + " _delegate_" + ctField.getName() + " = new " + collectionClass.getName() + "(_ref_" + ctField.getName() + ", " + "this);"), (CtClass)ctClass);
                    ctClass.addField(delegate);
                    if (Logger.isTraceEnabled()) {
                        Logger.trace((String)"%s added field %s", (Object[])new Object[]{ctClass.getName(), delegate});
                    }
                    CtMethod ctMethodGet = CtMethod.make((String)("public " + ctField.getType().getName() + " " + getter + "() { return this." + " _delegate_" + ctField.getName() + "; }"), (CtClass)ctClass);
                    ctClass.addMethod(ctMethodGet);
                    continue;
                }
                CtMethod ctMethodSet = CtMethod.make((String)("public void " + setter + "(" + ctField.getType().getName() + " value) { _ref_" + ctField.getName() + ".set(this, value); }"), (CtClass)ctClass);
                ctClass.addMethod(ctMethodSet);
            }
            catch (Exception e) {
                Logger.error((Throwable)e, (String)("Error in " + ENHANCER_NAME), (Object[])new Object[0]);
                throw new UnexpectedException("Error in " + ENHANCER_NAME, (Throwable)e);
            }
        }
        applicationClass.enhancedByteCode = ctClass.toBytecode();
        ctClass.defrost();
    }

    private AssociationProperty analyze(CtField ctField) {
        block7: {
            try {
                AssociationProperty ap = this.scan(ctField);
                if (ap == null) break block7;
                if (ap.oppField == null) {
                    for (CtField ofield : ap.type.getDeclaredFields()) {
                        AssociationProperty oppp = this.scan(ofield);
                        if (oppp == null || oppp.oppField != ctField) continue;
                        ap.opposite = oppp;
                        ap.oppField = oppp.field;
                        oppp.opposite = ap;
                        break;
                    }
                } else {
                    AssociationProperty oppp = this.scan(ap.oppField);
                    if (oppp != null && oppp.type == ctField.getDeclaringClass()) {
                        ap.opposite = oppp;
                        oppp.opposite = ap;
                        oppp.oppField = ap.field;
                    }
                }
                return ap.valid() && ap.opposite.valid() ? ap : null;
            }
            catch (NotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private AssociationProperty scan(CtField ctField) throws NotFoundException, ClassNotFoundException {
        AssociationProperty ap = new AssociationProperty();
        for (javassist.bytecode.annotation.Annotation a : AssociationsEnhancer.getAnnotations((CtField)ctField).getAnnotations()) {
            Set memberNames;
            if (!a.getTypeName().matches("^javax\\.persistence\\.(One|Many)To(One|Many)$")) continue;
            ap.field = ctField;
            Matcher m = COLLECTION_REGEX.matcher(ctField.getType().getName());
            ap.many = m.matches();
            if (ap.many) {
                ap.list = "List".equals(m.group(1));
                FieldInfo fi = ctField.getFieldInfo();
                AttributeInfo signature = fi.getAttribute("Signature");
                if (signature != null) {
                    int index = new BigInteger(signature.get()).intValue();
                    String info = signature.getConstPool().getUtf8Info(index);
                    Matcher m2 = INFO_REGEX.matcher(info);
                    if (m2.matches()) {
                        CtClass targetClass;
                        String type = m2.group(2).replaceAll("/", ".");
                        ap.type = targetClass = ctField.getDeclaringClass().getClassPool().get(type);
                    }
                }
            } else {
                ap.type = ctField.getType();
            }
            if (ap.type == null || !this.hasAnnotation(ap.type, JAVAX_PERSISTENCE_ENTITY) || (memberNames = a.getMemberNames()) == null || !memberNames.contains("mappedBy")) continue;
            ap.oppField = ap.type.getField(a.getMemberValue("mappedBy").toString().replaceAll("^\"|\"$", ""));
        }
        return ap.type != null ? ap : null;
    }

    protected boolean hasAnnotation(CtMethod ctMethod, String annotation) throws ClassNotFoundException {
        for (Object object : ctMethod.getAvailableAnnotations()) {
            Annotation ann = (Annotation)object;
            if (!ann.annotationType().getName().equals(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isProperty(CtField ctField) {
        return !ctField.getName().matches("^[A-Z]") && Modifier.isPublic(ctField.getModifiers()) && !Modifier.isFinal(ctField.getModifiers()) && !Modifier.isStatic(ctField.getModifiers());
    }

    public static String qq(String s) {
        return "\"" + s + "\"";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AssociationsPropertyAccessor {
    }

    private static class AssociationProperty {
        CtField field;
        CtClass type;
        CtField oppField;
        boolean many;
        boolean list;
        AssociationProperty opposite;

        private AssociationProperty() {
        }

        boolean valid() {
            return this.field != null && this.type != null && this.oppField != null && this.opposite != null;
        }

        public String toString() {
            return this.field.getDeclaringClass().getName() + "." + this.field.getName() + ":" + this.type.getName() + "[" + (this.many ? "*" + (this.list ? "(List)" : "(Set)") : "1") + "]";
        }
    }
}

