/*
 * Decompiled with CFR 0.152.
 */
package play.modules.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import play.Logger;
import play.modules.associations.AbstractAssociativeCollection;
import play.modules.associations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociativeList<T>
extends AbstractAssociativeCollection<T>
implements List<T> {
    public AssociativeList(Reference reference, Object owner) {
        super(reference, owner);
    }

    @Override
    public void link(T t) {
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" AssociativeList.link %s %s --> %s", (Object[])new Object[]{this.owner(), this.ref().field().getName(), t});
        }
        this.link(t, -1);
    }

    public void link(T t, int position) {
        if (position < 0) {
            this.delegate().add(t);
        } else {
            this.delegate().add(position, t);
        }
    }

    private void linkOpposite(T t) {
        this.ref().opposite().link(t, this.owner());
    }

    @Override
    public void unlink(T t) {
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" AssociativeList.unlink %s %s -x- %s", (Object[])new Object[]{this.owner(), this.ref().field().getName(), t});
        }
        this.unlink(t, -1);
    }

    public void unlink(T t, int position) {
        if (position < 0) {
            this.delegate().remove(t);
        } else if (position < this.delegate().size() && this.delegate().get(position) == t) {
            this.delegate().remove(position);
        } else {
            this.delegate().remove(t);
        }
    }

    private void unlinkOpposite(T current) {
        this.ref().opposite().unlink(current, this.owner());
    }

    @Override
    public T set(int index, T t) {
        if (t == null) {
            return this.remove(index);
        }
        T current = this.get(index);
        if (current != t) {
            this.unlink(current, index);
            this.unlinkOpposite(current);
            if (!this.ref().opposite().isCollection()) {
                this.ref().opposite().set(t, null);
            }
            this.link(t, index);
            this.linkOpposite(t);
        }
        return current;
    }

    @Override
    public T remove(int index) {
        T o = this.get(index);
        this.unlink(o, index);
        this.unlinkOpposite(o);
        return o;
    }

    @Override
    public void add(int index, T t) {
        if (t == null) {
            throw new IllegalArgumentException("null is not allowed in associations");
        }
        if (index >= 0 && index == this.indexOf(t)) {
            return;
        }
        if (!this.ref().opposite().isCollection()) {
            this.ref().opposite().set(t, null);
        }
        this.link(t, index);
        this.linkOpposite(t);
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null is not allowed in associations");
        }
        if (this.indexOf(t) >= 0) {
            return false;
        }
        int size = this.delegate().size();
        if (!this.ref().opposite().isCollection()) {
            this.ref().opposite().set(t, null);
        }
        this.link(t, -1);
        this.linkOpposite(t);
        return size != this.delegate().size();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int sz = this.size();
        for (T t : new ArrayList<T>(collection)) {
            if (t == null) continue;
            this.add(t);
        }
        return this.size() != sz;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        int sz = this.size();
        for (T t : new ArrayList<T>(collection)) {
            if (t == null) continue;
            this.add(index++, t);
        }
        return this.size() != sz;
    }

    @Override
    public void clear() {
        List<T> del = this.delegate();
        for (int i = del.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AssociativeList) {
            AssociativeList other = (AssociativeList)object;
            if (this.size() != other.size() || this.owner() != other.owner() || this.ref() != other.ref()) {
                return false;
            }
            List<T> del = this.delegate();
            int size = del.size();
            for (int i = 0; i < size; ++i) {
                if (del.get(i).equals(other.delegate().get(i))) continue;
                return false;
            }
            return true;
        }
        return this == object;
    }

    @Override
    public T get(int index) {
        return this.delegate().get(index);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate()).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.delegate().indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.delegate().lastIndexOf(object);
    }

    public List<T> delegate() {
        try {
            ArrayList delegate = (ArrayList)this.ref().field().get(this.owner());
            if (delegate == null) {
                delegate = new ArrayList();
                this.ref().field().set(this.owner(), delegate);
            }
            return delegate;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListIter(0);
    }

    @Override
    public ListIterator<T> listIterator(int anIndex) {
        return new ListIter(anIndex);
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        int index = this.indexOf(object);
        if (index >= 0) {
            int sz = this.size();
            this.remove(index);
            return this.size() != sz;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<?> i = new ArrayList(collection).iterator();
        while (i.hasNext()) {
            changed = this.remove(i.next()) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        List<T> del = this.delegate();
        for (int i = del.size() - 1; i >= 0; --i) {
            if (collection.contains(del.get(i))) continue;
            this.remove(i);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public List<T> subList(int from, int to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate().toArray(a);
    }

    public String toString() {
        return this.delegate().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIter
    extends Iter
    implements ListIterator<T> {
        ListIter(int anIndex) {
            this.cursor = anIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public T previous() {
            int i = this.cursor - 1;
            Object previous = AssociativeList.this.get(i);
            this.last = i;
            this.cursor = i;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(T t) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            try {
                AssociativeList.this.set(this.last, t);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(T t) {
            try {
                AssociativeList.this.add(this.cursor++, t);
                this.last = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter
    implements Iterator<T> {
        int cursor = 0;
        int last = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != AssociativeList.this.size();
        }

        @Override
        public T next() {
            try {
                Object next = AssociativeList.this.get(this.cursor);
                this.last = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            try {
                AssociativeList.this.remove(this.last);
                if (this.last < this.cursor) {
                    --this.cursor;
                }
                this.last = -1;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

