/*
 * Decompiled with CFR 0.152.
 */
package play.modules.associations;

import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import play.Logger;
import play.modules.associations.AbstractAssociativeCollection;
import play.modules.associations.AssociativeCollection;
import play.modules.associations.AssociativeList;
import play.modules.associations.AssociativeSet;

public class Reference {
    private Class clazz;
    private String fieldName;
    private Class oppClazz;
    private String oppFieldName;
    private Field field;
    private Field delegate;
    private Reference opposite;
    private Boolean collection;

    public Reference(Class clazz, String fieldName, Class oppClass, String oppFieldName) {
        this.clazz = clazz;
        this.fieldName = fieldName;
        this.oppClazz = oppClass;
        this.oppFieldName = oppFieldName;
    }

    public Field field() {
        if (this.field == null) {
            try {
                this.field = this.clazz.getField(this.fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return this.field;
    }

    public Field delegate() {
        if (this.delegate == null) {
            try {
                this.delegate = this.clazz.getField("_delegate_" + this.fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("error resolving _delegate_" + this.fieldName + " in class " + this.clazz.getName(), e);
            }
        }
        return this.delegate;
    }

    public Reference opposite() {
        if (this.opposite == null) {
            try {
                Field oppRefField = this.oppClazz.getField("_ref_" + this.oppFieldName);
                this.opposite = (Reference)oppRefField.get(null);
                if (Logger.isTraceEnabled()) {
                    Logger.trace((String)"%s.%s opposite is %s", (Object[])new Object[]{this.clazz.getName(), this.fieldName, oppRefField});
                }
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.opposite;
    }

    public boolean isCollection() {
        if (this.collection == null) {
            this.collection = Collection.class.isAssignableFrom(this.field().getType()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.collection;
    }

    public void link(Object owner, Object target) {
        if (this.isCollection()) {
            if (Logger.isTraceEnabled()) {
                Logger.trace((String)" link (coll) %s: %s --> %s", (Object[])new Object[]{owner, this.fieldName, target});
            }
            try {
                AbstractAssociativeCollection del;
                AbstractCollection raw = (ArrayList)this.field().get(owner);
                if (raw == null) {
                    if (List.class.isAssignableFrom(this.field().getType())) {
                        raw = new ArrayList();
                    } else if (Set.class.isAssignableFrom(this.field().getType())) {
                        raw = new HashSet();
                    } else {
                        throw new IllegalArgumentException("unsupported field type " + this.field().getType());
                    }
                    this.field().set(owner, raw);
                }
                if ((del = (AssociativeList<Object>)this.delegate().get(owner)) == null) {
                    if (List.class.isAssignableFrom(this.field().getType())) {
                        del = new AssociativeList<Object>(this, owner);
                    } else if (Set.class.isAssignableFrom(this.field().getType())) {
                        del = new AssociativeSet(this, owner);
                    } else {
                        throw new IllegalArgumentException("unsupported field type " + this.field().getType());
                    }
                }
                del.link(target);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" link (single) %s: %s --> %s", (Object[])new Object[]{owner, this.fieldName, target});
        }
        try {
            this.field().set(owner, target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlink(Object owner, Object target) {
        if (this.isCollection()) {
            if (Logger.isTraceEnabled()) {
                Logger.trace((String)" unlink (coll) %s: %s -x- %s", (Object[])new Object[]{owner, this.fieldName, target});
            }
            try {
                AssociativeCollection del = (AssociativeCollection)this.delegate().get(owner);
                if (del == null) return;
                del.unlink(target);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" unlink (single) %s: %s -x- %s", (Object[])new Object[]{owner, this.fieldName, target});
        }
        try {
            this.field().set(owner, null);
            return;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void set(Object owner, Object target) {
        Object current = this.current(owner);
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)"%s set: '%s': %s => %s)", (Object[])new Object[]{owner, this.fieldName, current, target});
        }
        if (current != target) {
            if (current != null) {
                if (target != null && !this.opposite().isCollection()) {
                    this.opposite().set(target, null);
                }
                this.opposite().unlink(current, owner);
                current = null;
            }
            if (target != null) {
                this.opposite().link(target, owner);
            }
            this.link(owner, target);
        }
    }

    public Object current(Object owner) {
        try {
            return (this.isCollection() ? this.delegate() : this.field()).get(owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

