/*
 * Decompiled with CFR 0.152.
 */
package play.modules.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import play.Logger;
import play.modules.associations.AbstractAssociativeCollection;
import play.modules.associations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociativeSet<T>
extends AbstractAssociativeCollection<T>
implements Set<T> {
    public AssociativeSet(Reference reference, Object owner) {
        super(reference, owner);
    }

    @Override
    public void link(T t) {
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" AssociativeSet.link %s %s --> %s", (Object[])new Object[]{this.owner(), this.ref().field().getName(), t});
        }
        this.delegate().add(t);
    }

    private void linkOpposite(T t) {
        this.ref().opposite().link(t, this.owner());
    }

    @Override
    public void unlink(T t) {
        if (Logger.isTraceEnabled()) {
            Logger.trace((String)" AssociativeSet.unlink %s %s -x- %s", (Object[])new Object[]{this.owner(), this.ref().field().getName(), t});
        }
        this.delegate().remove(t);
    }

    private void unlinkOpposite(T t) {
        this.ref().opposite().unlink(t, this.owner());
    }

    @Override
    public boolean add(T t) {
        if (t == null) {
            throw new IllegalArgumentException("null is not allowed in associations");
        }
        int size = this.delegate().size();
        if (!this.ref().opposite().isCollection()) {
            this.ref().opposite().set(t, null);
        }
        this.link(t);
        this.linkOpposite(t);
        return size != this.size();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        for (T t : new ArrayList<T>(collection)) {
            if (t == null) continue;
            this.add(t);
        }
        return collection.size() > 0;
    }

    @Override
    public void clear() {
        Set<T> del = this.delegate();
        while (del.size() > 0) {
            this.remove(del.iterator().next());
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate().contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AssociativeSet) {
            return ((Object)this.delegate()).equals(((AssociativeSet)object).delegate());
        }
        return this == object;
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate()).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    public Set<T> delegate() {
        try {
            HashSet delegate = (HashSet)this.ref().field().get(this.owner());
            if (delegate == null) {
                delegate = new HashSet();
                this.ref().field().set(this.owner(), delegate);
            }
            return delegate;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object object) {
        Set<T> del = this.delegate();
        int size = del.size();
        if (del.contains(object)) {
            this.unlink(object);
            this.unlinkOpposite(object);
            return del.size() != size;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean changed = false;
        Iterator<?> i = new ArrayList(collection).iterator();
        while (i.hasNext()) {
            changed = this.remove(i.next()) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean changed = false;
        Set<T> del = this.delegate();
        HashSet<T> copy = new HashSet<T>(del);
        for (Object t : copy) {
            if (collection.contains(t)) continue;
            this.remove(t);
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate().toArray(a);
    }

    public String toString() {
        return this.delegate().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Iter
    implements Iterator<T> {
        Iterator<T> i;
        T current;

        private Iter() {
            this.i = new HashSet(AssociativeSet.this.delegate()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public T next() {
            this.current = this.i.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            AssociativeSet.this.remove(this.current);
            this.current = null;
        }
    }
}

