/*
 * Decompiled with CFR 0.152.
 */
package bhave;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedList;
import models.terms.BArticle;
import models.terms.BConjunction;
import models.terms.BObject;
import models.terms.BSubject;
import models.terms.BSynonym;
import models.terms.BTerm;
import models.terms.BVerb;
import play.classloading.enhancers.PropertiesEnhancer;

public class BTermDeserializer
implements JsonDeserializer<BTerm> {
    public BTerm deserialize(JsonElement json, Type typeOf, JsonDeserializationContext context) throws JsonParseException {
        JsonObject termJson = json.getAsJsonObject();
        JsonElement idValue = termJson.get("id");
        if (idValue != null) {
            BTerm term;
            Long id = Long.valueOf(idValue.getAsString());
            BTerm bTerm = term = (BTerm)BTerm.findById(id);
            BTerm.BTermType bTermType = null;
            bTermType = (BTerm.BTermType)((Object)PropertiesEnhancer.FieldAccessor.invokeReadProperty((Object)((Object)bTerm), (String)"type", (String)"models.terms.BTerm", (String)"bhave.BTermDeserializer.deserialize, line 23"));
            switch (bTermType) {
                case Article: {
                    return (BTerm)BArticle.findById(id);
                }
                case Conjunction: {
                    return (BTerm)BConjunction.findById(id);
                }
                case Object: {
                    return (BTerm)BObject.findById(id);
                }
                case Subject: {
                    return (BTerm)BSubject.findById(id);
                }
                case Synonym: {
                    return (BTerm)BSynonym.findById(id);
                }
                case Verb: {
                    return (BTerm)BVerb.findById(id);
                }
            }
            System.err.println("WTF? Is this a new Term type?");
            return null;
        }
        switch (BTerm.BTermType.valueOf(termJson.get("type").getAsString())) {
            case Article: {
                return new BArticle(termJson.get("name").getAsString());
            }
            case Conjunction: {
                return new BConjunction(termJson.get("name").getAsString());
            }
            case Object: {
                return new BObject(termJson.get("name").getAsString(), BObject.BObjectType.valueOf(termJson.get("objectType").getAsString()), termJson.get("value").getAsString());
            }
            case Subject: {
                return new BSubject(termJson.get("name").getAsString());
            }
            case Synonym: {
                Type collectionType = new TypeToken<LinkedList<Long>>(this){
                    final /* synthetic */ BTermDeserializer this$0;
                    {
                        this.this$0 = bTermDeserializer;
                    }
                }.getType();
                LinkedList to = (LinkedList)new Gson().fromJson(termJson.get("to"), collectionType);
                return new BSynonym(termJson.get("name").getAsString(), to);
            }
            case Verb: {
                return new BVerb(termJson.get("name").getAsString(), termJson.get("command").getAsString());
            }
        }
        System.err.println("WTF? Is this a new Term type?");
        return null;
    }
}

