/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResponse
implements Serializable {
    private static final Log LOG = LogFactory.getLog(WebResponse.class);
    private long loadTime_;
    private WebResponseData responseData_;
    private WebRequest request_;

    public WebResponse(WebResponseData responseData, URL url, HttpMethod requestMethod, long loadTime) {
        this(responseData, new WebRequest(url, requestMethod), loadTime);
    }

    public WebResponse(WebResponseData responseData, WebRequest request, long loadTime) {
        this.responseData_ = responseData;
        this.request_ = request;
        this.loadTime_ = loadTime;
    }

    @Deprecated
    public WebRequest getRequestSettings() {
        return this.request_;
    }

    public WebRequest getWebRequest() {
        return this.request_;
    }

    public List<NameValuePair> getResponseHeaders() {
        return this.responseData_.getResponseHeaders();
    }

    public String getResponseHeaderValue(String headerName) {
        for (NameValuePair pair : this.responseData_.getResponseHeaders()) {
            if (!pair.getName().equalsIgnoreCase(headerName)) continue;
            return pair.getValue();
        }
        return null;
    }

    public int getStatusCode() {
        return this.responseData_.getStatusCode();
    }

    public String getStatusMessage() {
        return this.responseData_.getStatusMessage();
    }

    public String getContentType() {
        String contentTypeHeader = this.getResponseHeaderValue("content-type");
        if (contentTypeHeader == null) {
            return "";
        }
        int index = contentTypeHeader.indexOf(59);
        if (index == -1) {
            return contentTypeHeader;
        }
        return contentTypeHeader.substring(0, index);
    }

    public String getContentCharsetOrNull() {
        try {
            return EncodingSniffer.sniffEncoding(this.getResponseHeaders(), this.getContentAsStream());
        }
        catch (IOException e) {
            LOG.warn((Object)"Error trying to sniff encoding.", (Throwable)e);
            return null;
        }
    }

    public String getContentCharset() {
        String charset = this.getContentCharsetOrNull();
        if (charset == null) {
            charset = this.getWebRequest().getCharset();
        }
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public String getContentAsString() {
        return this.getContentAsString(this.getContentCharset());
    }

    public String getContentAsString(String encoding) {
        byte[] body = this.responseData_.getBody();
        if (body != null) {
            try {
                return new String(body, encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)("Attempted to use unsupported encoding '" + encoding + "'; using default system encoding."));
                return new String(body);
            }
        }
        return null;
    }

    public InputStream getContentAsStream() {
        return this.responseData_.getInputStream();
    }

    @Deprecated
    public byte[] getContentAsBytes() {
        return this.responseData_.getBody();
    }

    public long getLoadTime() {
        return this.loadTime_;
    }
}

