/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.view.View;
import android.webkit.WebSettings;
import com.google.common.base.Preconditions;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.ChromeClientWrapper;
import org.openqa.selenium.android.library.JavascriptExecutor;
import org.openqa.selenium.android.library.JavascriptInterface;
import org.openqa.selenium.android.library.ViewAdapter;
import org.openqa.selenium.android.library.ViewClientWrapper;
import org.openqa.selenium.android.library.ViewFactory;

class WebDriverView {
    private static JavascriptInterface jsInterface = new JavascriptInterface(new JavascriptExecutor());
    private AndroidWebDriver driver;
    private ViewFactory factory;
    private ViewClientWrapper viewc;
    private ChromeClientWrapper chromec;
    private View.OnFocusChangeListener focusListener;

    WebDriverView(AndroidWebDriver driver, ViewFactory factory, ViewClientWrapper viewc, ChromeClientWrapper chromec, View.OnFocusChangeListener focusListener) {
        Preconditions.checkNotNull((Object)driver);
        Preconditions.checkNotNull((Object)factory);
        this.driver = driver;
        this.factory = factory;
        this.viewc = viewc;
        this.chromec = chromec;
        this.chromec.setWebDriverView(this);
        this.focusListener = focusListener == null ? new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean b) {
            }
        } : focusListener;
    }

    ViewAdapter create() {
        this.chromec.setDriver(this.driver);
        this.viewc.setDriver(this.driver);
        ViewAdapter view = this.factory.createNewView(this.driver.getActivity());
        view.setWebChromeClient(this.chromec);
        view.setWebViewClient(this.viewc);
        view.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View view, boolean focused) {
                if (!focused) {
                    WebDriverView.this.driver.setEditAreaHasFocus(true);
                }
                WebDriverView.this.focusListener.onFocusChange(view, focused);
            }
        });
        view.addJavascriptInterface(jsInterface, "webdriver");
        WebDriverView.initWebViewSettings(view);
        return view;
    }

    private WebDriverView() {
    }

    private static void initWebViewSettings(ViewAdapter view) {
        view.clearCache(true);
        view.clearFormData();
        view.clearHistory();
        view.clearView();
        view.requestFocus(130);
        view.setFocusable(true);
        view.setFocusableInTouchMode(true);
        WebSettings settings = view.getSettings();
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportMultipleWindows(true);
        settings.setBuiltInZoomControls(true);
        settings.setJavaScriptEnabled(true);
        settings.setDatabaseEnabled(true);
        settings.setDomStorageEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setSaveFormData(true);
        settings.setSavePassword(false);
        settings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        settings.setLoadWithOverviewMode(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setDefaultZoom(WebSettings.ZoomDensity.valueOf((String)"MEDIUM"));
        settings.setUseWideViewPort(true);
        settings.setMinimumFontSize(1);
        settings.setMinimumLogicalFontSize(1);
        settings.setDefaultFontSize(16);
        settings.setDefaultFixedFontSize(13);
        settings.setPluginState(WebSettings.PluginState.ON);
        settings.setGeolocationEnabled(true);
        settings.setGeolocationDatabasePath("/data/data/webdriver");
        view.setNetworkAvailable(true);
    }
}

