/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONWriter;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.selenesedriver.SeleneseFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteAsyncScript
implements SeleneseFunction<Object> {
    private long timeoutMillis = 0L;

    @Override
    public Object apply(Selenium selenium, Map<String, ?> parameters) {
        String value;
        StringWriter sw = new StringWriter();
        try {
            new JSONWriter((Writer)sw).object().key("script").value(parameters.get("script")).key("args").value(parameters.get("args")).key("timeout").value(this.timeoutMillis).endObject();
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        String script = "core.script.execute(" + sw + ")";
        try {
            value = selenium.getEval(script);
        }
        catch (SeleniumException e) {
            if (e.getMessage().startsWith("ScriptTimeoutError")) {
                throw new TimeoutException(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        return this.populateReturnValue(value);
    }

    private Object populateReturnValue(String value) {
        if ("__undefined__".equals(value)) {
            return null;
        }
        if (value.matches("^\\d+$")) {
            return Long.parseLong(value);
        }
        if (value.matches("^\\d+\\.\\d+$")) {
            return Double.parseDouble(value);
        }
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    public SeleneseFunction<Object> setScriptTimeout() {
        return new SeleneseFunction<Object>(){

            @Override
            public Object apply(Selenium selenium, Map<String, ?> args) {
                ExecuteAsyncScript.this.timeoutMillis = ((Number)args.get("ms")).longValue();
                return null;
            }
        };
    }
}

