# BrowserID module for the play framework

## What is BrowserID ?

BrowserID is an experimental new way of signing into websites. The goal with BrowserID is to design something safe and easy for users and the developers.

Yet another authentication mechanism !  Please read further…


## How is BrowserID better than other authentication mechanisms ?

Well, probably not the right place to discuss this, but…

* Installed in minutes (really...)
* No need to register an App, or setup oauth/application keys
* Also works from localhost, convenient for development 
* Clean specifications (no false interpretations)
* Authored by MozillaLabs, a reference

## What does the module provide ?

* An implementation of BrowserID similar to Play's Secure.class
* A sample application

## Usage:

**3 minutes**, success guarantied… follow these steps:

### 1. Add a module dependency

Edit your application dependency file `conf/dependency.yml`, add the following reference:


```yaml
require:
    - play -> browserid {version}
```

Then run from your application's root folder

```bash
 $ play dependencies . 
```

This will download and setup the module in your application.


### 2. Configure the module

Edit `conf/application.conf` and add the following properties at the end of the file:

```properties
# The audience is used by BrowserID to identify the requesting party.
# Set to localhost:9000 for this demo but should be changed for your particular site
# This is typically the host making the request to the BrowserID servers. So if you run behind a proxy, please provide the proxy url
browserid.audience=http://localhost:9000
%prod.browserid.audience=http://www.myserver.com

# Where to redirect upon a logout, but default the application root, but could point to any URL
browserid.logoutRedirect=/

# BrowserID recommends that during the authentication process, SSL shall be used between the page and the browserid module
# It is off for the purpose of this demonstration, if turned on - you need to ensure https://<yourhost>/login is accessible
browserid.enforcessl=false
%prod.browserid.enforcessl=true
```


### 3. Configure HTTP Routes

Edit your application's `conf/route` file, at the top, first line, add:

	*		/				module:browserid

This tells Play to merge all routes from the browserid module. The following routes should automatically be imported `/login` `/logout` `/authenticate`

### 4. Configure Authentication

Add `@With(BrowserIDSecure.class)` to any controller that needs protection.


```java
package controllers;

import play.mvc.Controller;
import play.mvc.With;
import controllers.BrowserIDSecure;

@With(BrowserIDSecure.class)
public class Application extends Controller {

    public static void index() {
        render();
    }

}
```

## Credits

BrowserID by the [Identity Team](http://identity.mozilla.com/) @ Mozilla Labs

play-browserid module by [Olivier Refalo](https://github.com/orefalo)

## History

version 1.0: First release
