/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import java.util.List;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterFinally;
import org.codehaus.aspectwerkz.annotation.AfterReturning;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.AsmAnnotations;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.annotation.Introduce;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionParserHelper;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.util.Strings;

public class AspectAnnotationParser {
    private static final AspectAnnotationParser INSTANCE = new AspectAnnotationParser();

    private AspectAnnotationParser() {
    }

    public static void parse(ClassInfo classInfo, AspectDefinition aspectDef, ClassLoader loader) {
        INSTANCE.doParse(classInfo, aspectDef, loader);
    }

    private void doParse(ClassInfo classInfo, AspectDefinition aspectDef, ClassLoader loader) {
        if (classInfo == null) {
            throw new IllegalArgumentException("class to parse can not be null");
        }
        Aspect aspectAnnotation = (Aspect)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Aspect", classInfo));
        String aspectName = classInfo.getName();
        String deploymentModelAsString = null;
        if (aspectAnnotation != null) {
            if (aspectAnnotation.value() != null) {
                deploymentModelAsString = aspectAnnotation.value();
            } else {
                if (aspectAnnotation.name() != null) {
                    aspectName = aspectAnnotation.name();
                }
                if (aspectAnnotation.deploymentModel() != null) {
                    deploymentModelAsString = aspectAnnotation.deploymentModel();
                }
            }
        }
        aspectDef.setDeploymentModel(DeploymentModel.getDeploymentModelFor(deploymentModelAsString));
        String className = classInfo.getName();
        this.parseFieldAttributes(classInfo, aspectDef);
        this.parseMethodAttributes(classInfo, className, aspectName, aspectDef);
    }

    private void parseFieldAttributes(ClassInfo classInfo, AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        if (classInfo == null) {
            return;
        }
        FieldInfo[] fieldList = classInfo.getFields();
        for (int i = 0; i < fieldList.length; ++i) {
            Introduce introduce;
            FieldInfo field = fieldList[i];
            Expression expression = (Expression)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Expression", field));
            if (expression != null) {
                if (field.getType().getName().equals(DeploymentScope.class.getName())) {
                    DefinitionParserHelper.createAndAddDeploymentScopeDef(field.getName(), expression.value(), aspectDef.getSystemDefinition());
                } else {
                    DefinitionParserHelper.createAndAddPointcutDefToAspectDef(field.getName(), expression.value(), aspectDef);
                }
            }
            if ((introduce = (Introduce)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Introduce", field))) == null) continue;
            DefinitionParserHelper.createAndAddInterfaceIntroductionDefToAspectDef(introduce.value(), field.getName(), field.getType().getName(), aspectDef);
        }
        this.parseFieldAttributes(classInfo.getSuperclass(), aspectDef);
    }

    private void parseMethodAttributes(ClassInfo classInfo, String aspectClassName, String aspectName, AspectDefinition aspectDef) {
        if (classInfo == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (aspectClassName == null) {
            throw new IllegalArgumentException("aspect class name can not be null");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null " + aspectClassName);
        }
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        List methodList = ClassInfoHelper.createMethodList(classInfo);
        this.parsePointcutAttributes(methodList, aspectDef);
        for (MethodInfo method : methodList) {
            try {
                this.parseAroundAttributes(method, aspectName, aspectClassName, aspectDef);
                this.parseBeforeAttributes(method, aspectName, aspectClassName, aspectDef);
                this.parseAfterAttributes(method, aspectName, aspectClassName, aspectDef);
            }
            catch (DefinitionException e) {
                System.err.println("AW::WARNING - unable to register advice: " + e.toString());
            }
        }
    }

    private void parsePointcutAttributes(List methodList, AspectDefinition aspectDef) {
        for (MethodInfo method : methodList) {
            Expression annotation = (Expression)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Expression", method));
            if (annotation == null) continue;
            DefinitionParserHelper.createAndAddPointcutDefToAspectDef(AspectAnnotationParser.getAdviceNameAsInSource(method), annotation.value(), aspectDef);
        }
    }

    private void parseAroundAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        Around aroundAnnotation = (Around)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Around", method));
        if (aroundAnnotation != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AROUND, aroundAnnotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAroundAdviceDefinition(adviceDef);
        }
    }

    private void parseBeforeAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        Before beforeAnnotation = (Before)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Before", method));
        if (beforeAnnotation != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.BEFORE, beforeAnnotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addBeforeAdviceDefinition(adviceDef);
        }
    }

    private void parseAfterAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        AfterFinally annotationFin;
        AfterThrowing annotationThr;
        AfterReturning annotationRet;
        After annotationAft = (After)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.After", method));
        if (annotationAft != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER, annotationAft.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        if ((annotationRet = (AfterReturning)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.AfterReturning", method))) != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_RETURNING, AspectAnnotationParser.getExpressionElseValue(annotationRet.value(), annotationRet.pointcut()), annotationRet.type(), aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        if ((annotationThr = (AfterThrowing)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.AfterThrowing", method))) != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_THROWING, AspectAnnotationParser.getExpressionElseValue(annotationThr.value(), annotationThr.pointcut()), annotationThr.type(), aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        if ((annotationFin = (AfterFinally)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.AfterFinally", method))) != null) {
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_FINALLY, annotationFin.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
    }

    private static String getAdviceNameAsInSource(MethodInfo methodInfo) {
        StringBuffer buffer = new StringBuffer(methodInfo.getName());
        if (methodInfo.getParameterNames() == null || methodInfo.getParameterNames().length != methodInfo.getParameterTypes().length || methodInfo.getParameterNames().length > 0 && methodInfo.getParameterNames()[0] == null) {
            return methodInfo.getName();
        }
        if (methodInfo.getParameterNames().length > 0) {
            buffer.append('(');
            for (int i = 0; i < methodInfo.getParameterNames().length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                String parameterName = methodInfo.getParameterNames()[i];
                buffer.append(methodInfo.getParameterTypes()[i].getName());
                buffer.append(' ').append(parameterName);
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    public static String getExpressionElseValue(String value, String pointcut) {
        if (!Strings.isNullOrEmpty(pointcut)) {
            return pointcut;
        }
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        throw new DefinitionException("neither expression nor value had a valid value");
    }
}

