/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.aspect.DefaultMixinFactory;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.intercept.Advisable;
import org.codehaus.aspectwerkz.intercept.AdvisableImpl;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;

public class MixinDefinition {
    private static final String DEFAULT_MIXIN_FACTORY = DefaultMixinFactory.class.getName().replace('/', '.');
    private DeploymentModel m_deploymentModel;
    private boolean m_isTransient;
    private final List m_methodsToIntroduce = new ArrayList();
    private final List m_interfaceClassNames = new ArrayList();
    private final String m_mixinImplClassName;
    private final WeakReference m_loaderRef;
    private ExpressionInfo[] m_expressionInfos = new ExpressionInfo[0];
    private String m_attribute = "";
    private String m_factoryClassName;
    private SystemDefinition m_systemDefinition;
    private Map m_parameters = new HashMap();

    public MixinDefinition(ClassInfo mixinClass, DeploymentModel deploymentModel, boolean isTransient, SystemDefinition systemDef) {
        if (this.isSystemMixin(mixinClass)) {
            mixinClass = this.defineSystemMixin(mixinClass.getClassLoader());
        } else {
            List allInterfaces = ClassInfoHelper.collectInterfaces(mixinClass);
            for (ClassInfo interfaceInfo : allInterfaces) {
                this.m_interfaceClassNames.add(interfaceInfo.getName());
            }
            List interfaceDeclaredMethods = ClassInfoHelper.collectMethodsFromInterfacesImplementedBy(mixinClass);
            List sortedMethodList = ClassInfoHelper.createInterfaceDefinedMethodList(mixinClass, interfaceDeclaredMethods);
            for (MethodInfo methodInfo : sortedMethodList) {
                this.m_methodsToIntroduce.add(methodInfo);
            }
        }
        this.m_mixinImplClassName = mixinClass.getName();
        this.m_loaderRef = new WeakReference<ClassLoader>(mixinClass.getClassLoader());
        this.m_systemDefinition = systemDef;
        this.m_expressionInfos = new ExpressionInfo[0];
        this.m_deploymentModel = deploymentModel;
        this.m_isTransient = isTransient;
        this.setFactoryClassName(DEFAULT_MIXIN_FACTORY);
    }

    public void setFactoryClassName(String factoryClassName) {
        this.m_factoryClassName = factoryClassName;
    }

    public String getFactoryClassName() {
        return this.m_factoryClassName;
    }

    public List getMethodsToIntroduce() {
        return this.m_methodsToIntroduce;
    }

    public DeploymentModel getDeploymentModel() {
        return this.m_deploymentModel;
    }

    public void setDeploymentModel(DeploymentModel deploymentModel) {
        this.m_deploymentModel = deploymentModel;
    }

    public boolean isTransient() {
        return this.m_isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.m_isTransient = isTransient;
    }

    public ClassInfo getMixinImpl() {
        return AsmClassInfo.getClassInfo(this.m_mixinImplClassName, (ClassLoader)this.m_loaderRef.get());
    }

    public ExpressionInfo[] getExpressionInfos() {
        return this.m_expressionInfos;
    }

    public List getInterfaceClassNames() {
        return this.m_interfaceClassNames;
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public void setAttribute(String attribute) {
        this.m_attribute = attribute;
    }

    public SystemDefinition getSystemDefinition() {
        return this.m_systemDefinition;
    }

    public void addExpressionInfo(ExpressionInfo expression) {
        ExpressionInfo[] tmpExpressions = new ExpressionInfo[this.m_expressionInfos.length + 1];
        System.arraycopy(this.m_expressionInfos, 0, tmpExpressions, 0, this.m_expressionInfos.length);
        tmpExpressions[this.m_expressionInfos.length] = expression;
        this.m_expressionInfos = new ExpressionInfo[this.m_expressionInfos.length + 1];
        System.arraycopy(tmpExpressions, 0, this.m_expressionInfos, 0, tmpExpressions.length);
    }

    public void addExpressionInfos(ExpressionInfo[] expressions) {
        ExpressionInfo[] tmpExpressions = new ExpressionInfo[this.m_expressionInfos.length + expressions.length];
        System.arraycopy(this.m_expressionInfos, 0, tmpExpressions, 0, this.m_expressionInfos.length);
        System.arraycopy(expressions, 0, tmpExpressions, this.m_expressionInfos.length, expressions.length);
        this.m_expressionInfos = new ExpressionInfo[this.m_expressionInfos.length + expressions.length];
        System.arraycopy(tmpExpressions, 0, this.m_expressionInfos, 0, tmpExpressions.length);
    }

    private ClassInfo defineSystemMixin(ClassLoader loader) {
        ClassInfo mixinClass = AsmClassInfo.getClassInfo(AdvisableImpl.class.getName(), loader);
        MethodInfo[] methods = mixinClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodInfo method = methods[i];
            if (!method.getName().startsWith("aw$") && !method.getName().startsWith("aw_")) continue;
            this.m_methodsToIntroduce.add(method);
        }
        this.m_interfaceClassNames.add(Advisable.class.getName());
        return mixinClass;
    }

    private boolean isSystemMixin(ClassInfo mixinClass) {
        return mixinClass.getName().equals(AdvisableImpl.class.getName());
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map getParameters() {
        return this.m_parameters;
    }
}

