/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.cflow.CflowBinding;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DeploymentScope;
import org.codehaus.aspectwerkz.definition.DocumentParser;
import org.codehaus.aspectwerkz.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.perx.PerObjectAspect;
import org.codehaus.aspectwerkz.transform.AspectWerkzPreProcessor;
import org.codehaus.aspectwerkz.util.SequencedHashMap;

public class SystemDefinition {
    public static final Map EMPTY_HASH_MAP = new HashMap();
    private final Map m_aspectMap = new SequencedHashMap();
    private final Map m_mixinMap = new SequencedHashMap();
    private String m_uuid = "default";
    private final Set m_includePackages = new HashSet();
    private final Set m_excludePackages = new HashSet();
    private final Set m_preparePackages = new HashSet();
    private final Map m_deploymentScopes = new HashMap();

    public SystemDefinition(String uuid) {
        this.setUuid(uuid);
    }

    private void setUuid(String uuid) {
        this.m_uuid = uuid;
    }

    public String getUuid() {
        return this.m_uuid;
    }

    public Set getIncludePackages() {
        return this.m_includePackages;
    }

    public Set getExcludePackages() {
        return this.m_excludePackages;
    }

    public Collection getAspectDefinitions() {
        ArrayList clone = new ArrayList(this.m_aspectMap.size());
        Iterator it = this.m_aspectMap.values().iterator();
        while (it.hasNext()) {
            clone.add(it.next());
        }
        return clone;
    }

    public Collection getMixinDefinitions() {
        ArrayList clone = new ArrayList(this.m_mixinMap.size());
        Iterator it = this.m_mixinMap.values().iterator();
        while (it.hasNext()) {
            clone.add(it.next());
        }
        return clone;
    }

    public Collection getAdviceDefinitions() {
        ArrayList adviceDefs = new ArrayList();
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            adviceDefs.addAll(aspectDef.getAroundAdviceDefinitions());
            adviceDefs.addAll(aspectDef.getBeforeAdviceDefinitions());
            adviceDefs.addAll(aspectDef.getAfterAdviceDefinitions());
        }
        return adviceDefs;
    }

    public AspectDefinition getAspectDefinition(String name) {
        return (AspectDefinition)this.m_aspectMap.get(name);
    }

    public List getMixinDefinitions(ExpressionContext ctx) {
        ArrayList<MixinDefinition> introDefs = new ArrayList<MixinDefinition>();
        for (MixinDefinition introDef : this.m_mixinMap.values()) {
            for (int i = 0; i < introDef.getExpressionInfos().length; ++i) {
                if (!introDef.getExpressionInfos()[i].getExpression().match(ctx)) continue;
                introDefs.add(introDef);
            }
        }
        return introDefs;
    }

    public List getInterfaceIntroductionDefinitions(ExpressionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        ArrayList<InterfaceIntroductionDefinition> interfaceIntroductionDefs = new ArrayList<InterfaceIntroductionDefinition>();
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            for (InterfaceIntroductionDefinition introDef : aspectDef.getInterfaceIntroductionDefinitions()) {
                ExpressionInfo[] expressionInfos = introDef.getExpressionInfos();
                for (int i = 0; i < expressionInfos.length; ++i) {
                    ExpressionInfo expressionInfo = expressionInfos[i];
                    ExpressionVisitor expression = expressionInfo.getExpression();
                    if (!expression.match(ctx)) continue;
                    interfaceIntroductionDefs.add(introDef);
                }
            }
        }
        return interfaceIntroductionDefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspect(AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        Map map = this.m_aspectMap;
        synchronized (map) {
            List cflowBindings;
            if (this.m_aspectMap.containsKey(aspectDef.getName())) {
                return;
            }
            if (DeploymentModel.PER_TARGET.equals(aspectDef.getDeploymentModel())) {
                this.addAspect(PerObjectAspect.getAspectDefinition(this, aspectDef));
            } else if (DeploymentModel.PER_THIS.equals(aspectDef.getDeploymentModel())) {
                this.addAspect(PerObjectAspect.getAspectDefinition(this, aspectDef));
            }
            for (AdviceDefinition adviceDefinition : aspectDef.getAdviceDefinitions()) {
                cflowBindings = CflowBinding.getCflowBindingsForCflowOf(adviceDefinition.getExpressionInfo());
                for (CflowBinding cflowBinding : cflowBindings) {
                    if (cflowBinding.isCflowBelow()) continue;
                    this.addAspect(cflowBinding.getAspectDefinition(this, aspectDef.getClassInfo().getClassLoader()));
                }
            }
            this.m_aspectMap.put(aspectDef.getName(), aspectDef);
            for (AdviceDefinition adviceDefinition : aspectDef.getAdviceDefinitions()) {
                cflowBindings = CflowBinding.getCflowBindingsForCflowOf(adviceDefinition.getExpressionInfo());
                for (CflowBinding cflowBinding : cflowBindings) {
                    if (!cflowBinding.isCflowBelow()) continue;
                    this.addAspect(cflowBinding.getAspectDefinition(this, aspectDef.getClassInfo().getClassLoader()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAspectOverwriteIfExists(AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        Map map = this.m_aspectMap;
        synchronized (map) {
            this.m_aspectMap.put(aspectDef.getName(), aspectDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMixinDefinition(MixinDefinition mixinDef) {
        if (mixinDef == null) {
            throw new IllegalArgumentException("mixin definition can not be null");
        }
        Map map = this.m_mixinMap;
        synchronized (map) {
            if (this.m_mixinMap.containsKey(mixinDef.getMixinImpl().getName())) {
                MixinDefinition def = (MixinDefinition)this.m_mixinMap.get(mixinDef.getMixinImpl().getName());
                def.addExpressionInfos(mixinDef.getExpressionInfos());
                return;
            }
            this.m_mixinMap.put(mixinDef.getMixinImpl().getName(), mixinDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludePackage(String includePackage) {
        Set set = this.m_includePackages;
        synchronized (set) {
            this.m_includePackages.add(includePackage + '.');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExcludePackage(String excludePackage) {
        Set set = this.m_excludePackages;
        synchronized (set) {
            this.m_excludePackages.add(excludePackage + '.');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreparePackage(String preparePackage) {
        Set set = this.m_preparePackages;
        synchronized (set) {
            this.m_preparePackages.add(preparePackage + '.');
        }
    }

    public Set getPreparePackages() {
        return this.m_preparePackages;
    }

    public boolean inIncludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        if (this.m_includePackages.isEmpty()) {
            return true;
        }
        for (String packageName : this.m_includePackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean inExcludePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        for (String packageName : this.m_excludePackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean inPreparePackage(String className) {
        if (className == null) {
            throw new IllegalArgumentException("class name can not be null");
        }
        for (String packageName : this.m_preparePackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPointcut(ExpressionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            for (AdviceDefinition adviceDef : aspectDef.getAdviceDefinitions()) {
                ExpressionVisitor expression;
                ExpressionInfo expressionInfo = adviceDef.getExpressionInfo();
                if (expressionInfo == null || !(expression = expressionInfo.getExpression()).match(ctx)) continue;
                if (AspectWerkzPreProcessor.DETAILS) {
                    System.out.println("[TRACE - match: " + expression + " @ " + aspectDef.getQualifiedName() + "/" + adviceDef.getName());
                    System.out.println("[       for     " + ctx.getReflectionInfo());
                    System.out.println("[       within  " + ctx.getWithinReflectionInfo());
                    System.out.println("[       type    " + ctx.getPointcutType().toString());
                }
                return true;
            }
        }
        return false;
    }

    public boolean isAdvised(ExpressionContext[] ctxs) {
        if (ctxs == null) {
            throw new IllegalArgumentException("context array can not be null");
        }
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            List advices = aspectDef.getAdviceDefinitions();
            for (AdviceDefinition adviceDef : advices) {
                for (int i = 0; i < ctxs.length; ++i) {
                    ExpressionContext ctx = ctxs[i];
                    ExpressionInfo expressionInfo = adviceDef.getExpressionInfo();
                    if (expressionInfo == null || !expressionInfo.getAdvisedClassFilterExpression().match(ctx)) continue;
                    if (AspectWerkzPreProcessor.DETAILS) {
                        System.out.println("[TRACE - earlymatch: " + expressionInfo + " @ " + aspectDef.getQualifiedName() + "/" + adviceDef.getName());
                        System.out.println("[       for          " + ctx.getReflectionInfo());
                        System.out.println("[       within       " + ctx.getWithinReflectionInfo());
                        System.out.println("[       type         " + ctx.getPointcutType().toString());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAdvised(ExpressionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            List advices = aspectDef.getAdviceDefinitions();
            for (AdviceDefinition adviceDef : advices) {
                ExpressionInfo expressionInfo = adviceDef.getExpressionInfo();
                if (expressionInfo == null || !expressionInfo.getAdvisedClassFilterExpression().match(ctx)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMixin(ExpressionContext[] ctxs) {
        if (ctxs == null) {
            throw new IllegalArgumentException("context array can not be null");
        }
        for (MixinDefinition introDef : this.m_mixinMap.values()) {
            ExpressionInfo[] expressionInfos = introDef.getExpressionInfos();
            for (int i = 0; i < expressionInfos.length; ++i) {
                ExpressionInfo expressionInfo = expressionInfos[i];
                for (int j = 0; j < ctxs.length; ++j) {
                    if (!expressionInfo.getExpression().match(ctxs[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasMixin(ExpressionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        for (MixinDefinition introDef : this.m_mixinMap.values()) {
            ExpressionInfo[] expressionInfos = introDef.getExpressionInfos();
            for (int i = 0; i < expressionInfos.length; ++i) {
                ExpressionInfo expressionInfo = expressionInfos[i];
                if (!expressionInfo.getExpression().match(ctx)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasIntroducedInterface(ExpressionContext[] ctxs) {
        if (ctxs == null) {
            throw new IllegalArgumentException("context array can not be null");
        }
        for (AspectDefinition aspectDef : this.m_aspectMap.values()) {
            for (InterfaceIntroductionDefinition introDef : aspectDef.getInterfaceIntroductionDefinitions()) {
                ExpressionInfo[] expressionInfos = introDef.getExpressionInfos();
                for (int i = 0; i < expressionInfos.length; ++i) {
                    ExpressionInfo expressionInfo = expressionInfos[i];
                    for (int j = 0; j < ctxs.length; ++j) {
                        if (!expressionInfo.getExpression().match(ctxs[i])) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean hasIntroducedInterface(ExpressionContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        for (AspectDefinition aspectDefinition : this.m_aspectMap.values()) {
            for (InterfaceIntroductionDefinition introDef : aspectDefinition.getInterfaceIntroductionDefinitions()) {
                ExpressionInfo[] expressionInfos = introDef.getExpressionInfos();
                for (int i = 0; i < expressionInfos.length; ++i) {
                    ExpressionInfo expressionInfo = expressionInfos[i];
                    if (!expressionInfo.getExpression().match(ctx)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Collection getDeploymentScopes() {
        return this.m_deploymentScopes.values();
    }

    public DeploymentScope getDeploymentScope(String name) {
        return (DeploymentScope)this.m_deploymentScopes.get(name);
    }

    public void addDeploymentScope(DeploymentScope deploymentScope) {
        this.m_deploymentScopes.put(deploymentScope.getName(), deploymentScope);
    }

    public boolean equals(Object o) {
        return ((SystemDefinition)o).m_uuid.equals(this.m_uuid);
    }

    public int hashCode() {
        return this.m_uuid.hashCode();
    }

    public static SystemDefinition createVirtualDefinitionAt(ClassLoader loader) {
        SystemDefinition def = new SystemDefinition(SystemDefinitionContainer.getVirtualDefinitionUuid(loader));
        DocumentParser.addVirtualAspect(def);
        return def;
    }
}

