/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Opcodes;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AsmNullAdapter;

public class ProxyDelegationCompiler {
    public static byte[] compileProxyFor(ClassLoader loader, Class[] interfaces, String proxyClassName) {
        ClassWriter proxyWriter = AsmHelper.newClassWriter(true);
        HashSet methodSignatures = new HashSet();
        String[] interfaceClassNames = new String[interfaces.length];
        String[] interfaceSignatures = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceClassNames[i] = interfaces[i].getName().replace('.', '/');
            interfaceSignatures[i] = 'L' + interfaceClassNames[i] + ';';
        }
        ProxyCompilerClassVisitor createProxy = new ProxyCompilerClassVisitor(proxyWriter, proxyClassName.replace('.', '/'), methodSignatures, interfaceClassNames, interfaceSignatures);
        for (int i = 0; i < interfaces.length; ++i) {
            ClassReader classReader;
            Class anInterface = interfaces[i];
            String interfaceClassName = anInterface.getName().replace('.', '/');
            InputStream in = null;
            try {
                in = loader != null ? loader.getResourceAsStream(interfaceClassName + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(interfaceClassName + ".class");
                classReader = new ClassReader(in);
            }
            catch (IOException e) {
                throw new WrappedRuntimeException("Cannot compile proxy for " + anInterface, e);
            }
            finally {
                try {
                    in.close();
                }
                catch (Throwable t) {}
            }
            classReader.accept(createProxy, true);
        }
        return proxyWriter.toByteArray();
    }

    public static class ProxyCompilerClassVisitor
    extends AsmNullAdapter.NullClassAdapter
    implements Opcodes,
    TransformationConstants {
        final ClassVisitor m_proxyCv;
        final String m_proxyClassName;
        final Set m_signatures;
        private int currentInterfaceIndex = 0;
        final String[] m_interfaceClassNames;
        final String[] m_interfaceSignatures;

        public ProxyCompilerClassVisitor(ClassVisitor proxyCv, String proxyClassName, Set signatures, String[] interfaceClassNames, String[] interfaceSignatures) {
            this.m_proxyCv = proxyCv;
            this.m_proxyClassName = proxyClassName;
            this.m_signatures = signatures;
            this.m_interfaceClassNames = interfaceClassNames;
            this.m_interfaceSignatures = interfaceSignatures;
            this.m_proxyCv.visit(AsmHelper.JAVA_VERSION, 4129, this.m_proxyClassName, null, "java/lang/Object", interfaceClassNames);
            for (int i = 0; i < interfaceClassNames.length; ++i) {
                this.m_interfaceSignatures[i] = 'L' + interfaceClassNames[i] + ';';
                this.m_proxyCv.visitField(4114, "DELEGATE_" + i, this.m_interfaceSignatures[i], null, null);
            }
            StringBuffer ctorDesc = new StringBuffer("(");
            for (int i = 0; i < interfaceClassNames.length; ++i) {
                ctorDesc.append(this.m_interfaceSignatures[i]);
            }
            ctorDesc.append(")V");
            MethodVisitor init = this.m_proxyCv.visitMethod(4097, "<init>", ctorDesc.toString(), null, null);
            init.visitVarInsn(25, 0);
            init.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
            for (int i = 0; i < interfaceClassNames.length; ++i) {
                init.visitVarInsn(25, 0);
                init.visitVarInsn(25, 1 + i);
                init.visitFieldInsn(181, this.m_proxyClassName, "DELEGATE_" + i, this.m_interfaceSignatures[i]);
            }
            init.visitInsn(177);
            init.visitMaxs(0, 0);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.m_signatures.contains(name + desc)) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            this.m_signatures.add(name + desc);
            MethodVisitor cv = this.m_proxyCv.visitMethod(access & 0xFFFFFBFF, name, desc, signature, exceptions);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, this.m_proxyClassName, "DELEGATE_" + this.currentInterfaceIndex, this.m_interfaceSignatures[this.currentInterfaceIndex]);
            AsmHelper.loadArgumentTypes(cv, Type.getArgumentTypes(desc), false);
            cv.visitMethodInsn(185, this.m_interfaceClassNames[this.currentInterfaceIndex], name, desc);
            AsmHelper.addReturnStatement(cv, Type.getReturnType(desc));
            cv.visitMaxs(0, 0);
            return cv;
        }

        public void visitEnd() {
            ++this.currentInterfaceIndex;
            super.visitEnd();
        }
    }
}

