/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.proxy;

import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.hook.impl.ClassPreProcessorHelper;
import org.codehaus.aspectwerkz.proxy.Proxy;
import org.codehaus.aspectwerkz.proxy.ProxySubclassingCompiler;
import org.codehaus.aspectwerkz.proxy.Uuid;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.backport175.reader.bytecode.AnnotationReader;
import org.codehaus.backport175.reader.bytecode.spi.BytecodeProvider;

public class ProxySubclassingStrategy {
    public static final String PROXY_SUFFIX_START = "$$ProxiedByAWSubclassing$$";
    private static final Map PROXY_CLASS_CACHE = new WeakHashMap();

    static Object newInstance(Class clazz) {
        try {
            Class proxyClass = ProxySubclassingStrategy.getProxyClassFor(clazz, true, false);
            return proxyClass.newInstance();
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException(t);
        }
    }

    static Object newInstance(Class clazz, Class[] argumentTypes, Object[] argumentValues) {
        try {
            Class proxyClass = ProxySubclassingStrategy.getProxyClassFor(clazz, true, false);
            return proxyClass.getDeclaredConstructor(argumentTypes).newInstance(argumentValues);
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException(t);
        }
    }

    static Object newInstance(Class clazz, boolean useCache, boolean makeAdvisable) {
        try {
            Class proxyClass = ProxySubclassingStrategy.getProxyClassFor(clazz, useCache, makeAdvisable);
            return proxyClass.newInstance();
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException(t);
        }
    }

    static Object newInstance(Class clazz, Class[] argumentTypes, Object[] argumentValues, boolean useCache, boolean makeAdvisable) {
        try {
            Class proxyClass = ProxySubclassingStrategy.getProxyClassFor(clazz, useCache, makeAdvisable);
            return proxyClass.getDeclaredConstructor(argumentTypes).newInstance(argumentValues);
        }
        catch (Throwable t) {
            throw new WrappedRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class getProxyClassFor(Class clazz, boolean useCache, boolean makeAdvisable) {
        if (clazz.getName().startsWith("java.")) {
            throw new RuntimeException("can not create proxies from system classes (java.*)");
        }
        if (!useCache) {
            return ProxySubclassingStrategy.getNewProxyClassFor(clazz, makeAdvisable);
        }
        Map map = PROXY_CLASS_CACHE;
        synchronized (map) {
            Object cachedProxyClass = PROXY_CLASS_CACHE.get(clazz);
            if (cachedProxyClass != null) {
                return (Class)cachedProxyClass;
            }
            Class proxyClass = ProxySubclassingStrategy.getNewProxyClassFor(clazz, makeAdvisable);
            PROXY_CLASS_CACHE.put(clazz, proxyClass);
            return proxyClass;
        }
    }

    private static Class getNewProxyClassFor(Class clazz, boolean makeAdvisable) {
        ClassLoader loader = clazz.getClassLoader();
        String proxyClassName = ProxySubclassingStrategy.getUniqueClassNameForProxy(clazz);
        if (makeAdvisable) {
            Proxy.makeProxyAdvisable(proxyClassName, loader);
        }
        final byte[] bytes = ProxySubclassingCompiler.compileProxyFor(clazz, proxyClassName);
        AnnotationReader.setBytecodeProviderFor(proxyClassName, loader, new BytecodeProvider(){

            public byte[] getBytecode(String className, ClassLoader loader) throws Exception {
                return bytes;
            }
        });
        byte[] transformedBytes = ClassPreProcessorHelper.defineClass0Pre(loader, proxyClassName, bytes, 0, bytes.length, null);
        return AsmHelper.defineClass(loader, transformedBytes, proxyClassName);
    }

    private static String getUniqueClassNameForProxy(Class clazz) {
        return clazz.getName().replace('.', '/') + PROXY_SUFFIX_START + new Long(Uuid.newUuid()).toString();
    }

    static String getUniqueClassNameFromProxy(String proxyClassName) {
        int index = proxyClassName.lastIndexOf(PROXY_SUFFIX_START);
        if (index > 0) {
            return proxyClassName.substring(0, index);
        }
        return null;
    }
}

