/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import java.lang.reflect.Modifier;

public final class TransformationUtil {
    public static String getPrefixedOriginalClinitName(String className) {
        return TransformationUtil.getPrefixedOriginalMethodName("aw_clinit", className);
    }

    public static String getPrefixedOriginalMethodName(String methodName, String className) {
        StringBuffer buf = new StringBuffer();
        buf.append("aw$original$_AW_$");
        buf.append(methodName);
        buf.append("$_AW_$");
        buf.append(className.replace('.', '_').replace('/', '_'));
        return buf.toString();
    }

    public static String getWrapperMethodName(String methodName, String methodDesc, String className, String prefix) {
        StringBuffer buf = new StringBuffer();
        buf.append("aw$");
        buf.append(prefix);
        buf.append(methodName.replace('<', '$').replace('>', '$'));
        buf.append(methodDesc.hashCode());
        buf.append(className.replace('.', '_').replace('/', '_'));
        return buf.toString().replace('-', '_');
    }

    public static String getInvokeSignatureForCodeJoinPoints(int codeModifiers, String codeDesc, String callerTypeName, String calleeTypeName) {
        StringBuffer sig = new StringBuffer("(");
        if (!Modifier.isStatic(codeModifiers)) {
            sig.append('L');
            sig.append(calleeTypeName);
            sig.append(';');
        }
        int index = codeDesc.lastIndexOf(41);
        sig.append(codeDesc.substring(1, index));
        sig.append('L');
        sig.append(callerTypeName);
        sig.append(';');
        sig.append(codeDesc.substring(index, codeDesc.length()));
        return sig.toString();
    }

    public static String getInvokeSignatureForFieldJoinPoints(int fieldModifiers, String fieldDesc, String callerTypeName, String calleeTypeName) {
        StringBuffer sig = new StringBuffer("(");
        if (!Modifier.isStatic(fieldModifiers)) {
            sig.append('L');
            sig.append(calleeTypeName);
            sig.append(';');
        }
        sig.append(fieldDesc);
        sig.append('L');
        sig.append(callerTypeName);
        sig.append(';');
        sig.append(')');
        sig.append(fieldDesc);
        return sig.toString();
    }

    public static String getInvokeSignatureForHandlerJoinPoints(String withinTypeName, String exceptionTypeName) {
        StringBuffer sig = new StringBuffer("(");
        sig.append('L');
        sig.append(exceptionTypeName);
        sig.append(';');
        sig.append('L');
        sig.append(exceptionTypeName);
        sig.append(';');
        sig.append('L');
        sig.append(withinTypeName);
        sig.append(';');
        sig.append(')');
        sig.append('L');
        sig.append(exceptionTypeName);
        sig.append(';');
        return sig.toString();
    }

    public static String getInvokeSignatureForConstructorCallJoinPoints(String calleeConstructorDesc, String callerTypeName, String calleeTypeName) {
        StringBuffer sig = new StringBuffer("(");
        int index = calleeConstructorDesc.lastIndexOf(41);
        sig.append(calleeConstructorDesc.substring(1, index));
        sig.append('L');
        sig.append(callerTypeName);
        sig.append(';');
        sig.append(")L");
        sig.append(calleeTypeName);
        sig.append(';');
        return sig.toString();
    }

    public static String getConstructorBodyMethodName(String calleeTypeName) {
        StringBuffer buf = new StringBuffer();
        buf.append("aw$original$_AW_$");
        buf.append("init");
        buf.append("$_AW_$");
        buf.append(calleeTypeName.replace('.', '_').replace('/', '_'));
        return buf.toString();
    }

    public static String getConstructorBodyMethodSignature(String ctorDesc, String calleeTypeName) {
        StringBuffer sig = new StringBuffer("(L");
        sig.append(calleeTypeName);
        sig.append(";");
        sig.append(ctorDesc.substring(1));
        return sig.toString();
    }

    public static String getJoinPointClassName(String thisClassName, String thisMemberName, String thisMemberDesc, String targetClassName, int joinPointType, int joinPointHash) {
        StringBuffer classNameBuf = new StringBuffer(thisClassName);
        classNameBuf.append('_');
        classNameBuf.append(joinPointType);
        classNameBuf.append('_');
        classNameBuf.append((thisMemberName + thisMemberDesc).hashCode());
        classNameBuf.append('_');
        classNameBuf.append(joinPointHash);
        if (joinPointType == 4 || joinPointType == 2 || joinPointType == 6 || joinPointType == 5) {
            classNameBuf.append('_').append(targetClassName.hashCode());
        }
        classNameBuf.append("___AW_JoinPoint");
        return classNameBuf.toString().replace('-', '_').replace('.', '/');
    }
}

