/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.MethodVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AfterObjectInitializationCodeAdapter;

public class FieldSetFieldGetVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private final ClassLoader m_loader;
    private final ClassInfo m_callerClassInfo;
    private Label m_lastLabelForLineNumber = EmittedJoinPoint.NO_LINE_NUMBER;

    public FieldSetFieldGetVisitor(ClassVisitor cv, ClassLoader loader, ClassInfo classInfo, Context ctx) {
        super(cv);
        this.m_loader = loader;
        this.m_callerClassInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.startsWith("aw$")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        return mv == null ? null : new ReplacePutFieldAndGetFieldInstructionCodeAdapter(mv, this.m_loader, this.m_callerClassInfo, this.m_ctx.getClassName(), name, desc);
    }

    public class ReplacePutFieldAndGetFieldInstructionCodeAdapter
    extends AfterObjectInitializationCodeAdapter {
        private final ClassLoader m_loader;
        private final ClassInfo m_callerClassInfo;
        private final String m_callerClassName;
        private final String m_callerMethodName;
        private final String m_callerMethodDesc;
        private final MemberInfo m_callerMemberInfo;

        public ReplacePutFieldAndGetFieldInstructionCodeAdapter(MethodVisitor ca, ClassLoader loader, ClassInfo callerClassInfo, String callerClassName, String callerMethodName, String callerMethodDesc) {
            super(ca, callerMethodName);
            this.m_loader = loader;
            this.m_callerClassInfo = callerClassInfo;
            this.m_callerClassName = callerClassName;
            this.m_callerMethodName = callerMethodName;
            this.m_callerMethodDesc = callerMethodDesc;
            if ("<clinit>".equals(this.m_callerMethodName)) {
                this.m_callerMemberInfo = this.m_callerClassInfo.staticInitializer();
            } else if ("<init>".equals(this.m_callerMethodName)) {
                int hash = AsmHelper.calculateConstructorHash(this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getConstructor(hash);
            } else {
                int hash = AsmHelper.calculateMethodHash(this.m_callerMethodName, this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getMethod(hash);
            }
            if (this.m_callerMemberInfo == null) {
                System.err.println("AW::WARNING metadata structure could not be build for method [" + this.m_callerClassInfo.getName().replace('/', '.') + '.' + this.m_callerMethodName + ':' + this.m_callerMethodDesc + ']');
            }
        }

        public void visitLabel(Label label) {
            FieldSetFieldGetVisitor.this.m_lastLabelForLineNumber = label;
            super.visitLabel(label);
        }

        public void visitFieldInsn(int opcode, String className, String fieldName, String fieldDesc) {
            if (className.endsWith("___AW_JoinPoint") || fieldName.startsWith("___AW_") || fieldName.startsWith("aw$") || fieldName.equals("serialVersionUID")) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
                return;
            }
            if (!this.m_isObjectInitialized) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
                return;
            }
            Type fieldType = Type.getType(fieldDesc);
            int joinPointHash = AsmHelper.calculateFieldHash(fieldName, fieldDesc);
            ClassInfo classInfo = AsmClassInfo.getClassInfo(className, this.m_loader);
            FieldInfo fieldInfo = this.getFieldInfo(classInfo, className, fieldName, fieldDesc, joinPointHash);
            if (opcode == 181 || opcode == 179) {
                this.handleFieldModification(fieldInfo, opcode, className, fieldName, fieldDesc, joinPointHash);
            } else if (opcode == 180 || opcode == 178) {
                this.handleFieldAccess(fieldInfo, opcode, className, fieldName, fieldDesc, joinPointHash, fieldType);
            } else {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
            }
        }

        private void handleFieldAccess(FieldInfo fieldInfo, int opcode, String className, String fieldName, String fieldDesc, int joinPointHash, Type fieldType) {
            if (this.m_callerMemberInfo == null) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
                return;
            }
            ExpressionContext ctx = new ExpressionContext(PointcutType.GET, fieldInfo, this.m_callerMemberInfo);
            if (this.fieldFilter(FieldSetFieldGetVisitor.this.m_ctx.getDefinitions(), ctx, fieldInfo)) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
            } else {
                FieldSetFieldGetVisitor.this.m_ctx.markAsAdvised();
                String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, className, 6, joinPointHash);
                AsmHelper.addDefaultValue(this, fieldType);
                if (Modifier.isStatic(this.m_callerMemberInfo.getModifiers())) {
                    this.visitInsn(1);
                } else {
                    this.visitVarInsn(25, 0);
                }
                super.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForFieldJoinPoints(fieldInfo.getModifiers(), fieldDesc, this.m_callerClassName, className));
                FieldSetFieldGetVisitor.this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(6, this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, this.m_callerMemberInfo.getModifiers(), className, fieldName, fieldDesc, fieldInfo.getModifiers(), joinPointHash, joinPointClassName, FieldSetFieldGetVisitor.this.m_lastLabelForLineNumber));
            }
        }

        private void handleFieldModification(FieldInfo fieldInfo, int opcode, String className, String fieldName, String fieldDesc, int joinPointHash) {
            if (this.m_callerMemberInfo == null) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
                return;
            }
            ExpressionContext ctx = new ExpressionContext(PointcutType.SET, fieldInfo, this.m_callerMemberInfo);
            if (this.fieldFilter(FieldSetFieldGetVisitor.this.m_ctx.getDefinitions(), ctx, fieldInfo)) {
                super.visitFieldInsn(opcode, className, fieldName, fieldDesc);
            } else {
                FieldSetFieldGetVisitor.this.m_ctx.markAsAdvised();
                String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, className, 5, joinPointHash);
                if (Modifier.isStatic(this.m_callerMemberInfo.getModifiers())) {
                    this.visitInsn(1);
                } else {
                    this.visitVarInsn(25, 0);
                }
                super.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForFieldJoinPoints(fieldInfo.getModifiers(), fieldDesc, this.m_callerClassName, className));
                int sort = Type.getType(fieldDesc).getSort();
                if (sort != 7 && sort != 8) {
                    super.visitInsn(87);
                } else {
                    super.visitInsn(88);
                }
                FieldSetFieldGetVisitor.this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(5, this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, this.m_callerMemberInfo.getModifiers(), className, fieldName, fieldDesc, fieldInfo.getModifiers(), joinPointHash, joinPointClassName, FieldSetFieldGetVisitor.this.m_lastLabelForLineNumber));
            }
        }

        private FieldInfo getFieldInfo(ClassInfo classInfo, String className, String fieldName, String fieldDesc, int joinPointHash) {
            FieldInfo fieldInfo = classInfo.getField(joinPointHash);
            if (fieldInfo == null) {
                throw new Error("field info metadata structure could not be build for field: " + className + '.' + fieldName + ':' + fieldDesc);
            }
            return fieldInfo;
        }

        public boolean fieldFilter(Set definitions, ExpressionContext ctx, FieldInfo fieldInfo) {
            if (fieldInfo.getName().startsWith("aw$original$_AW_$")) {
                return true;
            }
            Iterator it = definitions.iterator();
            while (it.hasNext()) {
                if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
                return false;
            }
            return true;
        }
    }
}

