/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.reader.bytecode;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.backport175.reader.bytecode.spi.BytecodeProvider;

public class DefaultBytecodeProvider
implements BytecodeProvider {
    public byte[] getBytecode(String className, ClassLoader loader) throws Exception {
        byte[] bytes;
        block10: {
            InputStream in = null;
            try {
                in = loader != null ? loader.getResourceAsStream(className.replace('.', '/') + ".class") : ClassLoader.getSystemClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
                if (in != null) {
                    bytes = this.toByteArray(in);
                    break block10;
                }
                throw new Exception("could not read class [" + className + "] as byte array");
            }
            catch (IOException e) {
                throw new Exception("could not read class [" + className + "]as byte array due to: " + e.toString());
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return bytes;
    }

    private byte[] toByteArray(InputStream in) throws IOException {
        byte[] bytes = new byte[in.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = in.read(bytes, len, bytes.length - len)) == -1) {
                if (len < bytes.length) {
                    c = new byte[len];
                    System.arraycopy(bytes, 0, c, 0, len);
                    bytes = c;
                }
                return bytes;
            }
            if ((len += n) != bytes.length) continue;
            c = new byte[bytes.length + 1000];
            System.arraycopy(bytes, 0, c, 0, len);
            bytes = c;
        }
    }
}

