/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.seda;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.seda.HazelcastSedaEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class HazelcastSedaProducer
extends DefaultProducer
implements AsyncProcessor {
    private final transient BlockingQueue queue;

    public HazelcastSedaProducer(HazelcastSedaEndpoint endpoint, BlockingQueue hzlq) {
        super((Endpoint)endpoint);
        this.queue = hzlq;
    }

    public void process(Exchange exchange) throws Exception {
        this.checkAndStore(exchange);
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.checkAndStore(exchange);
        callback.done(true);
        return true;
    }

    private void checkAndStore(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        Object obj = !(body instanceof Serializable) ? exchange.getIn().getBody(byte[].class) : body;
        this.queue.add(obj);
    }
}

