/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.latches;

import java.util.concurrent.TimeUnit;
import org.multiverse.api.latches.Latch;
import org.multiverse.instrumentation.InstrumentationStamp;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class CheapLatch
implements Latch {
    public static final CheapLatch OPEN_LATCH = new CheapLatch(true);
    private volatile boolean isOpen;

    public CheapLatch() {
        this(false);
    }

    public CheapLatch(boolean isOpen) {
        this.isOpen = isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        if (this.isOpen) {
            return;
        }
        CheapLatch cheapLatch = this;
        synchronized (cheapLatch) {
            while (!this.isOpen) {
                this.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptible() {
        if (this.isOpen) {
            return;
        }
        boolean restoreInterrupt = false;
        try {
            CheapLatch cheapLatch = this;
            synchronized (cheapLatch) {
                while (!this.isOpen) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        restoreInterrupt = true;
                    }
                }
            }
        }
        finally {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.isOpen) {
            return;
        }
        CheapLatch cheapLatch = this;
        synchronized (cheapLatch) {
            this.isOpen = true;
            this.notifyAll();
        }
    }

    @Override
    public boolean tryAwait(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryAwaitUninterruptible(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryAwaitNs(long timeoutNs) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryAwaitUninterruptibleNs(long timeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return this.isOpen() ? "CheapLatch(open=true)" : "CheapLatch(open=false)";
    }
}

