/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.multiverse.instrumentation.Clazz;
import org.multiverse.instrumentation.DumpingFiler;
import org.multiverse.instrumentation.Environment;
import org.multiverse.instrumentation.Filer;
import org.multiverse.instrumentation.InstrumentationPhase;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.InstrumenterLogger;
import org.multiverse.instrumentation.Instrumentor;
import org.multiverse.instrumentation.NullInstrumenterLogger;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.MetadataRepository;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public class StandardInstrumentor
implements Instrumentor {
    private final MetadataRepository metadataRepository = new MetadataRepository();
    private final List<InstrumentationPhase> phases = new LinkedList<InstrumentationPhase>();
    private final String compilerName;
    private final String compilerVersion;
    private Filer filer;
    private boolean dumpBytecode;
    private File dumpDir = new File(System.getProperty("java.io.tmpdir"));
    private InstrumenterLogger log = new NullInstrumenterLogger();
    private final String stmName;
    private boolean optimize = false;
    private String excluded = "";
    private String included = "";

    public StandardInstrumentor(String compilerName, String compilerVersion, String stmName) {
        if (compilerName == null || compilerVersion == null || stmName == null) {
            throw new NullPointerException();
        }
        this.compilerName = compilerName;
        this.compilerVersion = compilerVersion;
        this.stmName = stmName;
        this.addDefaultExcludes();
    }

    private void addDefaultExcludes() {
        this.exclude("ch.qos.");
        this.exclude("com.gigaspaces.");
        this.exclude("com.jprofiler.");
        this.exclude("com.j_spaces.");
        this.exclude("com.ibm.");
        this.exclude("com.intellij.");
        this.exclude("com.sun.");
        this.exclude("com.tc.");
        this.exclude("com.tcclient.");
        this.exclude("groovy.");
        this.exclude("java.");
        this.exclude("javax.");
        this.exclude("oracle.");
        this.exclude("org.apache.");
        this.exclude("org.eclipse.");
        this.exclude("org.gradle.");
        this.exclude("org.codehaus.groovy.");
        this.exclude("org.hamcrest.");
        this.exclude("org.hibernate.");
        this.exclude("org.ietf.");
        this.exclude("org.jboss.");
        this.exclude("org.jruby.");
        this.exclude("org.junit.");
        this.exclude("org.junit.");
        this.exclude("org.kohsuke.");
        this.exclude("org.mockito.");
        this.exclude("org.mortbay.");
        this.exclude("org.multiverse.repackaged.");
        this.exclude("org.multiverse.repackaged.org.objectweb.asm.");
        this.exclude("org.omg.");
        this.exclude("org.openspaces.");
        this.exclude("org.osgi.");
        this.exclude("org.slf4j.");
        this.exclude("org.springframework.");
        this.exclude("org.w3c.");
        this.exclude("org.xml.");
        this.exclude("scala.");
        this.exclude("se.scalablesolutions.");
        this.exclude("sun.");
        this.exclude("sunw.");
    }

    protected final void add(InstrumentationPhase phase) {
        if (this.phases == null) {
            throw new NullPointerException();
        }
        this.phases.add(phase);
    }

    @Override
    public String getName() {
        return this.compilerName;
    }

    @Override
    public String getVersion() {
        return this.compilerVersion;
    }

    @Override
    public String getStmName() {
        return this.stmName;
    }

    @Override
    public String getExcluded() {
        return this.excluded;
    }

    @Override
    public String getIncluded() {
        return this.included;
    }

    @Override
    public void exclude(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (pattern.length() == 0) {
            return;
        }
        pattern = this.removeTrailingAndPrecedingSemicolons(pattern);
        this.excluded = this.excluded.length() == 0 ? pattern : this.excluded + ";" + pattern;
    }

    public String removeTrailingAndPrecedingSemicolons(String s) {
        return this.removePreceding(this.removeTrailing(s));
    }

    private String removeTrailing(String s) {
        if (s.endsWith(";")) {
            return this.removeTrailing(s.substring(0, s.length() - 1));
        }
        return s;
    }

    private String removePreceding(String s) {
        if (s.startsWith(";")) {
            return this.removeTrailing(s.substring(1, s.length()));
        }
        return s;
    }

    @Override
    public void include(String pattern) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if ((pattern = this.removeTrailingAndPrecedingSemicolons(pattern)).length() == 0) {
            return;
        }
        this.included = this.included.length() == 0 ? pattern : this.included + ";" + pattern;
    }

    @Override
    public void setLog(InstrumenterLogger log) {
        this.log = log == null ? new NullInstrumenterLogger() : log;
    }

    @Override
    public void setDumpBytecode(boolean dumpBytecode) {
        this.dumpBytecode = dumpBytecode;
    }

    @Override
    public void setDumpDirectory(File dumpDirectory) {
        if (dumpDirectory == null) {
            throw new NullPointerException();
        }
        this.dumpDir = dumpDirectory;
    }

    @Override
    public File getDumpDirectory() {
        return this.dumpDir;
    }

    @Override
    public void setFiler(Filer filer) {
        if (filer == null) {
            throw new NullPointerException();
        }
        this.filer = filer;
    }

    @Override
    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    @Override
    public Clazz process(Clazz originalClazz) {
        InstrumentationPhase phase;
        Clazz afterClazz;
        if (originalClazz.getClassLoader() == null) {
            this.log.important("Multiverse: Ignoring %s because it is a System class", originalClazz.getName());
            return originalClazz;
        }
        if (this.included.length() > 0 && !this.contains(this.included, originalClazz.getInternalName())) {
            this.log.lessImportant("Multiverse: Ignoring %s, because it is not included", originalClazz.getName());
            return originalClazz;
        }
        if (this.contains(this.excluded, originalClazz.getInternalName())) {
            this.log.important("Multiverse: Ignoring %s, because it is excluded", originalClazz.getName());
            return originalClazz;
        }
        this.log.important("Multiverse: Instrumenting %s", originalClazz.getName());
        EnvironmentImpl env = new EnvironmentImpl();
        Clazz beforeClazz = originalClazz;
        Iterator<InstrumentationPhase> i$ = this.phases.iterator();
        while (i$.hasNext() && (afterClazz = (phase = i$.next()).instrument(env, beforeClazz)) != null) {
            this.dump(phase, beforeClazz, afterClazz);
            beforeClazz = afterClazz;
        }
        if (originalClazz == beforeClazz) {
            this.log.lessImportant("Multiverse: Finished instrumenting %s (class was not modified)", originalClazz.getName());
        } else {
            this.log.lessImportant("Multiverse: Finished instrumenting of class %s", originalClazz.getName());
        }
        return beforeClazz;
    }

    private void dump(InstrumentationPhase step, Clazz beforeClazz, Clazz afterClazz) {
        if (!this.dumpBytecode || afterClazz == beforeClazz) {
            return;
        }
        File begin = new File(this.dumpDir, beforeClazz.getName() + "_" + step.getName() + "_before.class");
        AsmUtils.writeToFile(begin, beforeClazz.getBytecode());
        File end = new File(this.dumpDir, beforeClazz.getName() + "_" + step.getName() + "_after.class");
        AsmUtils.writeToFile(end, afterClazz.getBytecode());
    }

    private boolean contains(String all, String name) {
        StringTokenizer tokenizer = new StringTokenizer(all, ";");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (!name.startsWith(token)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.compilerName + "-" + this.compilerVersion;
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    class EnvironmentImpl
    implements Environment {
        EnvironmentImpl() {
        }

        @Override
        public boolean optimize() {
            return StandardInstrumentor.this.optimize;
        }

        @Override
        public boolean dumpBytecode() {
            return StandardInstrumentor.this.dumpBytecode;
        }

        @Override
        public Filer getFiler() {
            if (StandardInstrumentor.this.dumpBytecode) {
                return new DumpingFiler(StandardInstrumentor.this.filer, StandardInstrumentor.this.dumpDir);
            }
            return StandardInstrumentor.this.filer;
        }

        @Override
        public InstrumenterLogger getLog() {
            return StandardInstrumentor.this.log;
        }

        @Override
        public File getDumpDirectory() {
            return StandardInstrumentor.this.dumpDir;
        }

        @Override
        public MetadataRepository getMetadataRepository() {
            return StandardInstrumentor.this.metadataRepository;
        }
    }
}

