/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.instrumentation.asm;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalConstructor;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.TraceLevel;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.instrumentation.asm.AsmUtils;
import org.multiverse.instrumentation.metadata.ClassMetadata;
import org.multiverse.instrumentation.metadata.ClassMetadataExtractor;
import org.multiverse.instrumentation.metadata.CompactFamilyNameStrategy;
import org.multiverse.instrumentation.metadata.FamilyNameStrategy;
import org.multiverse.instrumentation.metadata.FieldMetadata;
import org.multiverse.instrumentation.metadata.MetadataRepository;
import org.multiverse.instrumentation.metadata.MethodMetadata;
import org.multiverse.instrumentation.metadata.MethodType;
import org.multiverse.instrumentation.metadata.TransactionMetadata;
import org.multiverse.repackaged.org.objectweb.asm.Opcodes;
import org.multiverse.repackaged.org.objectweb.asm.Type;
import org.multiverse.repackaged.org.objectweb.asm.tree.AbstractInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.AnnotationNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.ClassNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldInsnNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.FieldNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.InsnList;
import org.multiverse.repackaged.org.objectweb.asm.tree.MethodNode;
import org.multiverse.repackaged.org.objectweb.asm.tree.VarInsnNode;
import org.multiverse.utils.IOUtils;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class AsmClassMetadataExtractor
implements ClassMetadataExtractor,
Opcodes {
    private MetadataRepository metadataRepository;
    private FamilyNameStrategy familyNameStrategy;

    public AsmClassMetadataExtractor() {
        this(new CompactFamilyNameStrategy());
    }

    public AsmClassMetadataExtractor(FamilyNameStrategy familyNameStrategy) {
        if (familyNameStrategy == null) {
            throw new NullPointerException();
        }
        this.familyNameStrategy = familyNameStrategy;
    }

    @Override
    public void init(MetadataRepository metadataRepository) {
        if (metadataRepository == null) {
            throw new NullPointerException();
        }
        this.metadataRepository = metadataRepository;
    }

    @Override
    public ClassMetadata extract(String className, ClassLoader classLoader) {
        if (className == null) {
            throw new NullPointerException();
        }
        ClassMetadata classMetadata = new ClassMetadata(className);
        ClassNode classNode = this.loadClassNode(className, classLoader);
        if (classNode == null) {
            classMetadata.setIgnoredClass(true);
        } else {
            classMetadata.setAccess(classNode.access);
            if (this.isTransactional(classLoader, classNode)) {
                classMetadata.setIsTransactionalObject(true);
            }
            if (classNode.superName != null) {
                ClassMetadata superClassMetadata = this.metadataRepository.loadClassMetadata(classLoader, classNode.superName);
                classMetadata.setSuperClassMetadata(superClassMetadata);
            }
            for (String interfaceName : classNode.interfaces) {
                ClassMetadata interfaceMetadata = this.metadataRepository.loadClassMetadata(classLoader, interfaceName);
                classMetadata.getInterfaces().add(interfaceMetadata);
            }
            for (FieldNode fieldNode : classNode.fields) {
                this.extractFieldMetadata(classMetadata, fieldNode);
            }
            for (MethodNode methodNode : classNode.methods) {
                this.extractMethodMetadata(classMetadata, methodNode);
            }
        }
        return classMetadata;
    }

    private ClassNode loadClassNode(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        if (!this.existsClass(className, classLoader)) {
            return null;
        }
        return AsmUtils.loadAsClassNode(classLoader, className);
    }

    private boolean existsClass(String className, ClassLoader classLoader) {
        String fileName = className + ".class";
        InputStream is = classLoader.getResourceAsStream(fileName);
        if (is == null) {
            return false;
        }
        IOUtils.closeQuietly(is);
        return true;
    }

    private void extractMethodMetadata(ClassMetadata classMetadata, MethodNode methodNode) {
        MethodMetadata methodMetadata = classMetadata.createMethodMetadata(methodNode.name, methodNode.desc);
        methodMetadata.setAccess(methodNode.access);
        if (methodNode.exceptions != null) {
            for (String exception : methodNode.exceptions) {
                methodMetadata.addException(exception);
            }
        }
        TransactionMetadata transactionMetadata = null;
        if (!this.isInvisibleMethod(methodNode)) {
            if (classMetadata.isTransactionalObject()) {
                if (AsmClassMetadataExtractor.hasTransactionalMethodAnnotation(methodNode) || AsmClassMetadataExtractor.hasTransactionalConstructorAnnotation(methodNode)) {
                    transactionMetadata = this.createTransactionMetadata(classMetadata, methodNode);
                } else if (!AsmUtils.isStatic(methodNode)) {
                    transactionMetadata = this.createDefaultTransactionMetadata(classMetadata, methodNode);
                }
            } else if (AsmClassMetadataExtractor.hasTransactionalMethodAnnotation(methodNode)) {
                transactionMetadata = this.createTransactionMetadata(classMetadata, methodNode);
            } else if (AsmClassMetadataExtractor.hasTransactionalConstructorAnnotation(methodNode)) {
                transactionMetadata = this.createTransactionMetadata(classMetadata, methodNode);
            }
        }
        methodMetadata.setTransactionalMetadata(transactionMetadata);
        this.extractSetterMetadata(methodMetadata, methodNode);
        this.extractGetterMetadata(methodMetadata, methodNode);
    }

    private void extractSetterMetadata(MethodMetadata methodMetadata, MethodNode methodNode) {
        if (methodMetadata.isStatic() || methodMetadata.isNative() || methodMetadata.isAbstract()) {
            return;
        }
        Type[] argTypes = Type.getArgumentTypes(methodNode.desc);
        if (argTypes.length != 1) {
            return;
        }
        Type retType = Type.getReturnType(methodNode.desc);
        if (!Type.VOID_TYPE.equals(retType)) {
            return;
        }
        List<AbstractInsnNode> filteredInstructions = this.filterNoOps(methodNode.instructions);
        if (filteredInstructions.size() != 4) {
            return;
        }
        if (filteredInstructions.get(0).getOpcode() != 25) {
            return;
        }
        VarInsnNode insn1 = (VarInsnNode)filteredInstructions.get(0);
        if (insn1.var != 0) {
            return;
        }
        if (filteredInstructions.get(1).getType() != 2) {
            return;
        }
        VarInsnNode insn2 = (VarInsnNode)filteredInstructions.get(1);
        if (insn2.var != 1) {
            return;
        }
        if (filteredInstructions.get(2).getOpcode() != 181) {
            return;
        }
        FieldInsnNode insn3 = (FieldInsnNode)filteredInstructions.get(2);
        if (filteredInstructions.get(3).getOpcode() != 177) {
            return;
        }
        FieldMetadata field = methodMetadata.getClassMetadata().getFieldMetadata(insn3.name);
        methodMetadata.setGetterSetter(MethodType.setter, field);
    }

    private void extractGetterMetadata(MethodMetadata methodMetadata, MethodNode methodNode) {
        if (methodMetadata.isStatic() || methodMetadata.isNative() || methodMetadata.isAbstract()) {
            return;
        }
        Type[] argTypes = Type.getArgumentTypes(methodNode.desc);
        if (argTypes.length != 0) {
            return;
        }
        Type retType = Type.getReturnType(methodNode.desc);
        if (Type.VOID_TYPE.equals(retType)) {
            return;
        }
        List<AbstractInsnNode> filteredInstructions = this.filterNoOps(methodNode.instructions);
        if (filteredInstructions.size() != 3) {
            return;
        }
        AbstractInsnNode instr1 = filteredInstructions.get(0);
        if (instr1.getOpcode() != 25) {
            return;
        }
        VarInsnNode varInsnNode = (VarInsnNode)instr1;
        if (varInsnNode.var != 0) {
            return;
        }
        AbstractInsnNode instr2 = filteredInstructions.get(1);
        if (instr2.getOpcode() != 180) {
            return;
        }
        AbstractInsnNode instr3 = filteredInstructions.get(2);
        switch (instr3.getOpcode()) {
            case 172: {
                break;
            }
            case 173: {
                break;
            }
            case 174: {
                break;
            }
            case 175: {
                break;
            }
            case 176: {
                break;
            }
            default: {
                return;
            }
        }
        FieldInsnNode fieldInsnNode = (FieldInsnNode)instr2;
        FieldMetadata field = methodMetadata.getClassMetadata().getFieldMetadata(fieldInsnNode.name);
        methodMetadata.setGetterSetter(MethodType.getter, field);
    }

    private List<AbstractInsnNode> filterNoOps(InsnList instructions) {
        LinkedList<AbstractInsnNode> result = new LinkedList<AbstractInsnNode>();
        if (instructions == null) {
            return result;
        }
        for (int k = 0; k < instructions.size(); ++k) {
            AbstractInsnNode node = instructions.get(k);
            if (node.getOpcode() == -1) continue;
            result.add(node);
        }
        return result;
    }

    private boolean isInvisibleMethod(MethodNode methodNode) {
        return AsmClassMetadataExtractor.isExcluded(methodNode) || AsmClassMetadataExtractor.isSynthetic(methodNode.access);
    }

    private FieldMetadata extractFieldMetadata(ClassMetadata classMetadata, FieldNode fieldNode) {
        FieldMetadata fieldMetadata = classMetadata.createFieldMetadata(fieldNode.name);
        fieldMetadata.setAccess(fieldNode.access);
        fieldMetadata.setDesc(fieldNode.desc);
        if (this.isManagedField(classMetadata, fieldNode)) {
            fieldMetadata.setIsManaged(true);
        } else if (this.isManagedFieldWithFieldGranularity(classMetadata, fieldNode)) {
            fieldMetadata.setIsManaged(true);
            fieldMetadata.setHasFieldGranularity(true);
        }
        return fieldMetadata;
    }

    private boolean isTransactional(ClassLoader classLoader, ClassNode classNode) {
        String objectName = Type.getInternalName(Object.class);
        if (classNode.name.equals(objectName)) {
            return false;
        }
        if (AsmClassMetadataExtractor.hasTransactionalObjectAnnotation(classNode)) {
            return true;
        }
        ClassMetadata superClassMetadata = this.metadataRepository.loadClassMetadata(classLoader, classNode.superName);
        if (superClassMetadata.isTransactionalObject()) {
            return true;
        }
        for (String interfaceName : classNode.interfaces) {
            ClassMetadata interfaceMetadata = this.metadataRepository.loadClassMetadata(classLoader, interfaceName);
            if (!interfaceMetadata.isTransactionalObject()) continue;
            return true;
        }
        return false;
    }

    private boolean isManagedFieldWithFieldGranularity(ClassMetadata classMetadata, FieldNode field) {
        return classMetadata.isTransactionalObject() && AsmClassMetadataExtractor.hasFieldGranularity(field) && !this.isInvisibleField(field);
    }

    private boolean isManagedField(ClassMetadata classMetadata, FieldNode field) {
        return classMetadata.isTransactionalObject() && !this.isInvisibleField(field) && !AsmClassMetadataExtractor.hasFieldGranularity(field);
    }

    private boolean isInvisibleField(FieldNode fieldNode) {
        return AsmClassMetadataExtractor.isExcluded(fieldNode) || AsmUtils.isFinal(fieldNode) || AsmUtils.isStatic(fieldNode) || AsmClassMetadataExtractor.isSynthetic(fieldNode.access) || AsmClassMetadataExtractor.isVolatile(fieldNode);
    }

    private TransactionMetadata createDefaultTransactionMetadata(ClassMetadata classMetadata, MethodNode methodNode) {
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
        boolean throwsInterruptedException = methodMetadata.checkIfSpecificTransactionIsThrown(InterruptedException.class);
        TransactionMetadata transactionMetadata = new TransactionMetadata();
        if (methodNode.name.equals("<init>")) {
            transactionMetadata.maxRetries = 0;
            transactionMetadata.speculativeConfigurationEnabled = false;
            transactionMetadata.readOnly = false;
        } else {
            transactionMetadata.maxRetries = 1000;
            transactionMetadata.speculativeConfigurationEnabled = true;
            transactionMetadata.readOnly = null;
        }
        transactionMetadata.traceLevel = TraceLevel.none;
        transactionMetadata.trackReads = null;
        transactionMetadata.writeSkew = true;
        transactionMetadata.interruptible = throwsInterruptedException;
        transactionMetadata.familyName = this.familyNameStrategy.create(classMetadata.getName(), methodNode.name, methodNode.desc);
        transactionMetadata.timeoutNs = Long.MAX_VALUE;
        return transactionMetadata;
    }

    private TransactionMetadata createTransactionMetadata(ClassMetadata classMetadata, MethodNode methodNode) {
        TransactionMetadata txMetadata = new TransactionMetadata();
        AnnotationNode annotationNode = methodNode.name.equals("<init>") ? AsmUtils.getVisibleAnnotation(methodNode, TransactionalConstructor.class) : AsmUtils.getVisibleAnnotation(methodNode, TransactionalMethod.class);
        MethodMetadata methodMetadata = classMetadata.getMethodMetadata(methodNode.name, methodNode.desc);
        boolean throwsInterruptedException = methodMetadata.checkIfSpecificTransactionIsThrown(InterruptedException.class);
        txMetadata.familyName = this.familyNameStrategy.create(classMetadata.getName(), methodNode.name, methodNode.desc);
        txMetadata.interruptible = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "interruptible", throwsInterruptedException);
        txMetadata.writeSkew = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "writeSkew", true);
        if (txMetadata.writeSkew) {
            txMetadata.trackReads = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "trackReads", null);
        } else {
            Boolean tracking = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "trackReads", null);
            if (tracking == null || tracking.booleanValue()) {
                txMetadata.trackReads = true;
            }
        }
        long timeout = ((Number)AsmClassMetadataExtractor.getValue(annotationNode, "timeout", Long.MAX_VALUE)).longValue();
        String[] unit = (String[])AsmClassMetadataExtractor.getValue(annotationNode, "timeoutTimeUnit", new String[]{null, TimeUnit.SECONDS.name()});
        TimeUnit timeoutTimeUnit = TimeUnit.valueOf(unit[1]);
        txMetadata.timeoutNs = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : timeoutTimeUnit.toNanos(timeout);
        String[] logLevels = (String[])AsmClassMetadataExtractor.getValue(annotationNode, "traceLevel", new String[]{null, TraceLevel.none.name()});
        txMetadata.traceLevel = TraceLevel.valueOf(logLevels[1]);
        if (methodNode.name.equals("<init>")) {
            txMetadata.maxRetries = (Integer)AsmClassMetadataExtractor.getValue(annotationNode, "maxRetries", 0);
            txMetadata.speculativeConfigurationEnabled = false;
            txMetadata.readOnly = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "readonly", false);
        } else {
            txMetadata.maxRetries = (Integer)AsmClassMetadataExtractor.getValue(annotationNode, "maxRetries", 1000);
            txMetadata.speculativeConfigurationEnabled = true;
            txMetadata.readOnly = (Boolean)AsmClassMetadataExtractor.getValue(annotationNode, "readonly", null);
        }
        return txMetadata;
    }

    private static Object getValue(AnnotationNode node, String name, Object defaultValue) {
        if (node == null || node.values == null) {
            return defaultValue;
        }
        for (int k = 0; k < node.values.size(); k += 2) {
            String paramName = (String)node.values.get(k);
            if (!name.equals(paramName)) continue;
            return node.values.get(k + 1);
        }
        return defaultValue;
    }

    public static boolean isExcluded(FieldNode field) {
        return AsmUtils.hasVisibleAnnotation(field, NonTransactional.class);
    }

    public static boolean isExcluded(MethodNode methodNode) {
        return AsmUtils.hasVisibleAnnotation(methodNode, NonTransactional.class);
    }

    public static boolean hasFieldGranularity(FieldNode field) {
        return AsmUtils.hasVisibleAnnotation(field, FieldGranularity.class);
    }

    public static boolean hasTransactionalMethodAnnotation(MethodNode methodNode) {
        return AsmUtils.hasVisibleAnnotation(methodNode, TransactionalMethod.class);
    }

    public static boolean hasTransactionalConstructorAnnotation(MethodNode methodNode) {
        return AsmUtils.hasVisibleAnnotation(methodNode, TransactionalConstructor.class);
    }

    public static boolean hasTransactionalObjectAnnotation(ClassNode classNode) {
        return AsmUtils.hasVisibleAnnotation(classNode, TransactionalObject.class);
    }

    public static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    public static boolean isVolatile(FieldNode fieldNode) {
        return (fieldNode.access & 0x40) != 0;
    }
}

