/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.multiverse.api.PropagationLevel;
import org.multiverse.api.Stm;
import org.multiverse.api.TraceLevel;
import org.multiverse.api.TransactionConfiguration;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.TransactionFactoryBuilder;
import org.multiverse.api.backoff.BackoffPolicy;
import org.multiverse.api.clock.PrimitiveClock;
import org.multiverse.api.commitlock.CommitLockPolicy;
import org.multiverse.instrumentation.InstrumentationStamp;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticRefFactoryBuilder;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

@InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
public final class AlphaStm
implements Stm<AlphaTransactionFactoryBuilder, AlphaProgrammaticRefFactoryBuilder> {
    private static final Logger logger = Logger.getLogger(AlphaStm.class.getName());
    private static final AtomicLong anonoymousFamilyNameGenerator = new AtomicLong();
    private final TraceLevel traceLevel;
    private final PrimitiveClock clock;
    private final CommitLockPolicy commitLockPolicy;
    private final BackoffPolicy backoffPolicy;
    private final int maxRetries;
    private final int maxArraySize;
    private final boolean speculativeConfigEnabled;
    private final boolean optimizeConflictDetectionEnabled;
    private final boolean dirtyCheckEnabled;
    private final boolean quickReleaseWriteLocksEnabled;
    private final boolean explicitRetryAllowed;
    private final boolean readTrackingEnabled;
    private final boolean allowWriteSkew;
    private final boolean interruptible;
    private final AlphaProgrammaticRefFactoryBuilder refFactoryBuilder;
    private final int maxReadSpinCount;
    private final int syncToClock;

    private static String createAnonymousFamilyName() {
        return "TransactionFamily-" + anonoymousFamilyNameGenerator.incrementAndGet();
    }

    public static AlphaStm createFast() {
        return new AlphaStm(AlphaStmConfig.createFastConfig());
    }

    public static AlphaStm createDebug() {
        return new AlphaStm(AlphaStmConfig.createDebugConfig());
    }

    public AlphaStm() {
        this(AlphaStmConfig.createFastConfig());
    }

    public AlphaStm(AlphaStmConfig config) {
        if (config == null) {
            throw new NullPointerException("No configuration provided for STM");
        }
        config.ensureValid();
        this.speculativeConfigEnabled = config.speculativeConfigurationEnabled;
        this.optimizeConflictDetectionEnabled = config.optimizedConflictDetectionEnabled;
        this.dirtyCheckEnabled = config.dirtyCheckEnabled;
        this.maxArraySize = config.maxFixedUpdateSize;
        this.commitLockPolicy = config.commitLockPolicy;
        this.backoffPolicy = config.backoffPolicy;
        this.maxRetries = config.maxRetries;
        this.clock = config.clock;
        this.quickReleaseWriteLocksEnabled = config.quickReleaseWriteLocksEnabled;
        this.refFactoryBuilder = new AlphaProgrammaticRefFactoryBuilder(this);
        this.explicitRetryAllowed = config.explicitRetryAllowed;
        this.readTrackingEnabled = config.readTrackingEnabled;
        this.allowWriteSkew = config.allowWriteSkew;
        this.interruptible = config.interruptible;
        this.maxReadSpinCount = config.maxReadSpinCount;
        this.traceLevel = config.traceLevel;
        this.syncToClock = 0;
        if (this.clock.getVersion() == 0L) {
            this.clock.tick();
        }
        logger.info("Created a new AlphaStm instance");
    }

    @Override
    public AlphaTransactionFactoryBuilder getTransactionFactoryBuilder() {
        return new AlphaTransactionFactoryBuilder();
    }

    @Override
    public AlphaProgrammaticRefFactoryBuilder getProgrammaticRefFactoryBuilder() {
        return this.refFactoryBuilder;
    }

    public int getMaxReadSpinCount() {
        return this.maxReadSpinCount;
    }

    public CommitLockPolicy getAtomicObjectLockPolicy() {
        return this.commitLockPolicy;
    }

    public BackoffPolicy getBackoffPolicy() {
        return this.backoffPolicy;
    }

    public CommitLockPolicy getCommitLockPolicy() {
        return this.commitLockPolicy;
    }

    public boolean isDirtyCheckEnabled() {
        return this.dirtyCheckEnabled;
    }

    public int getMaxArraySize() {
        return this.maxArraySize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isOptimizeConflictDetectionEnabled() {
        return this.optimizeConflictDetectionEnabled;
    }

    public boolean isQuickReleaseWriteLocksEnabled() {
        return this.quickReleaseWriteLocksEnabled;
    }

    public boolean isSpeculativeConfigEnabled() {
        return this.speculativeConfigEnabled;
    }

    @Override
    public long getVersion() {
        return this.clock.getVersion();
    }

    public PrimitiveClock getClock() {
        return this.clock;
    }

    @InstrumentationStamp(instrumentorName="AlphaStmInstrumentor", instrumentorVersion="0.6")
    public class AlphaTransactionFactoryBuilder
    implements TransactionFactoryBuilder<AlphaTransaction, AlphaTransactionFactoryBuilder> {
        private final int maxRetries;
        private final boolean readonly;
        private final String familyName;
        private final boolean readTrackingEnabled;
        private final boolean writeSkewAllowed;
        private final CommitLockPolicy commitLockPolicy;
        private final BackoffPolicy backoffPolicy;
        private final SpeculativeConfiguration speculativeConfig;
        private final boolean interruptible;
        private final boolean dirtyCheck;
        private final boolean quickReleaseEnabled;
        private final boolean explicitRetryAllowed;
        private final long timeoutNs;
        private final int maxReadSpinCount;
        private final TraceLevel traceLevel;
        private final PropagationLevel propagationLevel;

        @Override
        public AlphaStm getStm() {
            return AlphaStm.this;
        }

        public AlphaTransactionFactoryBuilder() {
            this(true, alphaStm.readTrackingEnabled, AlphaStm.createAnonymousFamilyName(), alphaStm.maxRetries, alphaStm.allowWriteSkew, alphaStm.commitLockPolicy, alphaStm.backoffPolicy, SpeculativeConfiguration.createSpeculativeConfiguration(alphaStm.speculativeConfigEnabled, alphaStm.maxArraySize), alphaStm.interruptible, alphaStm.dirtyCheckEnabled, alphaStm.quickReleaseWriteLocksEnabled, alphaStm.explicitRetryAllowed, Long.MAX_VALUE, alphaStm.maxReadSpinCount, alphaStm.traceLevel, PropagationLevel.Requires);
        }

        public AlphaTransactionFactoryBuilder(boolean readonly, boolean readTrackingEnabled, String familyName, int maxRetries, boolean writeSkewAllowed, CommitLockPolicy commitLockPolicy, BackoffPolicy backoffPolicy, SpeculativeConfiguration speculativeConfig, boolean interruptible, boolean dirtyCheck, boolean quickReleaseEnabled, boolean explicitRetryAllowed, long timeoutNs, int maxReadSpinCount, TraceLevel traceLevel, PropagationLevel propagationLevel) {
            this.readonly = readonly;
            this.familyName = familyName;
            this.maxRetries = maxRetries;
            this.readTrackingEnabled = readTrackingEnabled;
            this.writeSkewAllowed = writeSkewAllowed;
            this.commitLockPolicy = commitLockPolicy;
            this.backoffPolicy = backoffPolicy;
            this.speculativeConfig = speculativeConfig;
            this.interruptible = interruptible;
            this.dirtyCheck = dirtyCheck;
            this.quickReleaseEnabled = quickReleaseEnabled;
            this.explicitRetryAllowed = explicitRetryAllowed;
            this.timeoutNs = timeoutNs;
            this.maxReadSpinCount = maxReadSpinCount;
            this.traceLevel = traceLevel;
            this.propagationLevel = propagationLevel;
        }

        @Override
        public BackoffPolicy getBackoffPolicy() {
            return this.backoffPolicy;
        }

        @Override
        public boolean isDirtyCheckEnabled() {
            return AlphaStm.this.dirtyCheckEnabled;
        }

        @Override
        public boolean isExplicitRetryAllowed() {
            return this.explicitRetryAllowed;
        }

        @Override
        public String getFamilyName() {
            return this.familyName;
        }

        @Override
        public boolean isReadonly() {
            return this.readonly;
        }

        @Override
        public boolean isReadTrackingEnabled() {
            return this.readTrackingEnabled;
        }

        @Override
        public boolean isInterruptible() {
            return this.interruptible;
        }

        @Override
        public CommitLockPolicy getCommitLockPolicy() {
            return this.commitLockPolicy;
        }

        @Override
        public boolean isSpeculativeConfigurationEnabled() {
            return AlphaStm.this.speculativeConfigEnabled;
        }

        @Override
        public boolean isWriteSkewAllowed() {
            return this.writeSkewAllowed;
        }

        @Override
        public boolean isQuickReleaseEnabled() {
            return this.quickReleaseEnabled;
        }

        @Override
        public long getTimeoutNs() {
            return this.timeoutNs;
        }

        @Override
        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public TraceLevel getTraceLevel() {
            return this.traceLevel;
        }

        @Override
        public PropagationLevel getPropagationLevel() {
            return this.propagationLevel;
        }

        @Override
        public AlphaTransactionFactoryBuilder setPropagationLevel(PropagationLevel level) {
            if (level == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, level);
        }

        @Override
        public AlphaTransactionFactoryBuilder setTraceLevel(TraceLevel traceLevel) {
            if (traceLevel == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, traceLevel, this.propagationLevel);
        }

        @Override
        public int getMaxReadSpinCount() {
            return this.maxReadSpinCount;
        }

        @Override
        public AlphaTransactionFactoryBuilder setMaxReadSpinCount(int maxReadSpinCount) {
            if (maxReadSpinCount < 0) {
                throw new IllegalArgumentException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setTimeoutNs(long timeoutNs) {
            if (timeoutNs < 0L) {
                throw new IllegalArgumentException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setFamilyName(String familyName) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setQuickReleaseEnabled(boolean quickReleaseEnabled) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setMaxRetries(int maxRetries) {
            if (maxRetries < 0) {
                throw new IllegalArgumentException(String.format("retryCount can't be smaller than 0, found %s", maxRetries));
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setReadonly(boolean readonly) {
            SpeculativeConfiguration newSpeculativeConfig = this.speculativeConfig.withSpeculativeReadonlyDisabled();
            return new AlphaTransactionFactoryBuilder(readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setReadTrackingEnabled(boolean readTrackingEnabled) {
            SpeculativeConfiguration newSpeculativeConfig = this.speculativeConfig.withSpeculativeNonAutomaticReadTrackingDisabled();
            return new AlphaTransactionFactoryBuilder(this.readonly, readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setInterruptible(boolean interruptible) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setCommitLockPolicy(CommitLockPolicy commitLockPolicy) {
            if (commitLockPolicy == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setSpeculativeConfigurationEnabled(boolean enabled) {
            SpeculativeConfiguration newSpeculativeConfig = SpeculativeConfiguration.createSpeculativeConfiguration(enabled, AlphaStm.this.maxArraySize);
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, newSpeculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setWriteSkewAllowed(boolean allowWriteSkew) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, allowWriteSkew, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == null) {
                throw new NullPointerException();
            }
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setDirtyCheckEnabled(boolean dirtyCheckEnabled) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, dirtyCheckEnabled, this.quickReleaseEnabled, this.explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public AlphaTransactionFactoryBuilder setExplicitRetryAllowed(boolean explicitRetryAllowed) {
            return new AlphaTransactionFactoryBuilder(this.readonly, this.readTrackingEnabled, this.familyName, this.maxRetries, this.writeSkewAllowed, this.commitLockPolicy, this.backoffPolicy, this.speculativeConfig, this.interruptible, this.dirtyCheck, this.quickReleaseEnabled, explicitRetryAllowed, this.timeoutNs, this.maxReadSpinCount, this.traceLevel, this.propagationLevel);
        }

        @Override
        public TransactionFactory<AlphaTransaction> build() {
            if (this.speculativeConfig.isEnabled()) {
                return this.createSpeculativeTxFactory();
            }
            if (this.readonly) {
                return this.createNonSpeculativeReadonlyTxFactory();
            }
            return this.createNonSpeculativeUpdateTxFactory();
        }

        private TransactionFactory<AlphaTransaction> createSpeculativeTxFactory() {
            return new TransactionFactory<AlphaTransaction>(){
                final ReadonlyConfiguration ro_nort;
                final ReadonlyConfiguration ro_rt;
                final UpdateConfiguration up_rt;
                final UpdateConfiguration up_nort;
                {
                    this.ro_nort = new ReadonlyConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, false, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                    this.ro_rt = new ReadonlyConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, true, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                    this.up_rt = new UpdateConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.commitLockPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, true, AlphaTransactionFactoryBuilder.this.writeSkewAllowed, AlphaStm.this.optimizeConflictDetectionEnabled, true, AlphaTransactionFactoryBuilder.this.quickReleaseEnabled, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                    this.up_nort = new UpdateConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.commitLockPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, false, true, AlphaStm.this.optimizeConflictDetectionEnabled, true, AlphaTransactionFactoryBuilder.this.quickReleaseEnabled, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                }

                @Override
                public Stm getStm() {
                    return AlphaStm.this;
                }

                @Override
                public TransactionConfiguration getTransactionConfiguration() {
                    return this.ro_nort;
                }

                @Override
                public TransactionFactoryBuilder getTransactionFactoryBuilder() {
                    return AlphaTransactionFactoryBuilder.this;
                }

                @Override
                public AlphaTransaction start() {
                    AlphaTransaction tx = this.create();
                    tx.start();
                    return tx;
                }

                @Override
                public AlphaTransaction create() {
                    boolean finalReadonly = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeReadonlyEnabled() ? AlphaTransactionFactoryBuilder.this.speculativeConfig.isReadonly() : AlphaTransactionFactoryBuilder.this.readonly;
                    boolean finalAutomaticReadTracking = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeNoReadTrackingEnabled() ? AlphaTransactionFactoryBuilder.this.speculativeConfig.isReadTrackingEnabled() : AlphaTransactionFactoryBuilder.this.readTrackingEnabled;
                    boolean speculativeSizeEnabled = AlphaTransactionFactoryBuilder.this.speculativeConfig.isSpeculativeSizeEnabled();
                    if (finalReadonly) {
                        if (finalAutomaticReadTracking) {
                            if (speculativeSizeEnabled) {
                                int size = AlphaTransactionFactoryBuilder.this.speculativeConfig.getOptimalSize();
                                if (size <= 1) {
                                    return new MonoReadonlyAlphaTransaction(this.ro_rt);
                                }
                                if (size < AlphaStm.this.maxArraySize) {
                                    return new ArrayReadonlyAlphaTransaction(this.ro_rt, size);
                                }
                                return new MapReadonlyAlphaTransaction(this.ro_rt);
                            }
                            return new MapReadonlyAlphaTransaction(this.ro_rt);
                        }
                        return new NonTrackingReadonlyAlphaTransaction(this.ro_nort);
                    }
                    UpdateConfiguration config = finalAutomaticReadTracking ? this.up_rt : this.up_nort;
                    if (speculativeSizeEnabled) {
                        int size = AlphaTransactionFactoryBuilder.this.speculativeConfig.getOptimalSize();
                        if (size <= 1) {
                            return new MonoUpdateAlphaTransaction(config);
                        }
                        if (size <= AlphaStm.this.maxArraySize) {
                            return new ArrayUpdateAlphaTransaction(config, size);
                        }
                        return new MapUpdateAlphaTransaction(config);
                    }
                    return new MapUpdateAlphaTransaction(config);
                }
            };
        }

        private TransactionFactory<AlphaTransaction> createNonSpeculativeReadonlyTxFactory() {
            return new TransactionFactory<AlphaTransaction>(){
                ReadonlyConfiguration config;
                {
                    this.config = new ReadonlyConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, AlphaTransactionFactoryBuilder.this.readTrackingEnabled, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                }

                @Override
                public Stm getStm() {
                    return AlphaStm.this;
                }

                @Override
                public TransactionConfiguration getTransactionConfiguration() {
                    return this.config;
                }

                @Override
                public TransactionFactoryBuilder getTransactionFactoryBuilder() {
                    return AlphaTransactionFactoryBuilder.this;
                }

                @Override
                public AlphaTransaction create() {
                    if (AlphaTransactionFactoryBuilder.this.readTrackingEnabled) {
                        return new MapReadonlyAlphaTransaction(this.config);
                    }
                    return new NonTrackingReadonlyAlphaTransaction(this.config);
                }

                @Override
                public AlphaTransaction start() {
                    AlphaTransaction tx = this.create();
                    tx.start();
                    return tx;
                }
            };
        }

        private TransactionFactory<AlphaTransaction> createNonSpeculativeUpdateTxFactory() {
            if (!this.readTrackingEnabled && !this.writeSkewAllowed) {
                String msg = String.format("Can't createReference transactionfactory for transaction family '%s' because an update transaction without automaticReadTracking and with writeSkew disallowed is not possible", this.familyName);
                throw new IllegalStateException(msg);
            }
            return new TransactionFactory<AlphaTransaction>(){
                UpdateConfiguration config;
                {
                    this.config = new UpdateConfiguration(AlphaStm.this.clock, AlphaTransactionFactoryBuilder.this.backoffPolicy, AlphaTransactionFactoryBuilder.this.commitLockPolicy, AlphaTransactionFactoryBuilder.this.familyName, AlphaTransactionFactoryBuilder.this.speculativeConfig, AlphaTransactionFactoryBuilder.this.maxRetries, AlphaTransactionFactoryBuilder.this.interruptible, AlphaTransactionFactoryBuilder.this.readTrackingEnabled, AlphaTransactionFactoryBuilder.this.writeSkewAllowed, AlphaStm.this.optimizeConflictDetectionEnabled, true, AlphaTransactionFactoryBuilder.this.quickReleaseEnabled, AlphaTransactionFactoryBuilder.this.explicitRetryAllowed, AlphaTransactionFactoryBuilder.this.timeoutNs, AlphaTransactionFactoryBuilder.this.maxReadSpinCount, this, AlphaTransactionFactoryBuilder.this.traceLevel, AlphaStm.this.syncToClock, AlphaTransactionFactoryBuilder.this.propagationLevel);
                }

                @Override
                public TransactionConfiguration getTransactionConfiguration() {
                    return this.config;
                }

                @Override
                public Stm getStm() {
                    return AlphaStm.this;
                }

                @Override
                public TransactionFactoryBuilder getTransactionFactoryBuilder() {
                    return AlphaTransactionFactoryBuilder.this;
                }

                @Override
                public AlphaTransaction start() {
                    AlphaTransaction tx = this.create();
                    tx.start();
                    return tx;
                }

                @Override
                public AlphaTransaction create() {
                    return new MapUpdateAlphaTransaction(this.config);
                }
            };
        }
    }
}

